/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.instrument;

import java.util.Collections;
import java.util.List;
import org.objectweb.asm.util.Printer;

public class BasicBlock {
    public final List<Integer> opcodeSequence;
    public final List<Integer> switchCases;
    public final List<String> allocatedTypes;
    private long energyCost;

    public BasicBlock(List<Integer> opcodes, List<Integer> switchCases, List<String> allocatedTypes) {
        this.opcodeSequence = Collections.unmodifiableList(opcodes);
        this.switchCases = Collections.unmodifiableList(switchCases);
        this.allocatedTypes = Collections.unmodifiableList(allocatedTypes);
    }

    public void setEnergyCost(long energyCost) {
        this.energyCost = energyCost;
    }

    public long getEnergyCost() {
        return this.energyCost;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("BasicBlock{");
        this.opcodeSequence.stream().map(i -> Printer.OPCODES[i]).forEach(s -> builder.append((String)s).append('\n'));
        builder.append('}');
        return builder.toString();
    }
}

