/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.instrument;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.aion.avm.core.instrument.BasicBlock;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class BlockBuildingMethodVisitor
extends MethodVisitor {
    private final List<BasicBlock> buildingList = new ArrayList<BasicBlock>();
    private List<Integer> currentBuildingBlock = new ArrayList<Integer>();
    private List<Integer> currentBlockSwitches = new ArrayList<Integer>();
    private List<String> currentAllocationList = new ArrayList<String>();

    public BlockBuildingMethodVisitor() {
        super(458752);
    }

    public List<BasicBlock> getBlockList() {
        return Collections.unmodifiableList(this.buildingList);
    }

    public void visitEnd() {
        this.handleLabel();
        this.currentBuildingBlock = null;
        this.currentBlockSwitches = null;
        this.currentAllocationList = null;
    }

    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        this.currentBuildingBlock.add(opcode);
    }

    public void visitIincInsn(int var, int increment) {
        this.currentBuildingBlock.add(132);
    }

    public void visitInsn(int opcode) {
        this.currentBuildingBlock.add(opcode);
        if (191 == opcode) {
            this.handleLabel();
        }
    }

    public void visitIntInsn(int opcode, int operand) {
        this.currentBuildingBlock.add(opcode);
    }

    public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        this.currentBuildingBlock.add(186);
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.currentBuildingBlock.add(opcode);
        this.handleLabel();
    }

    public void visitLabel(Label label) {
        this.handleLabel();
    }

    public void visitLdcInsn(Object value) {
        this.currentBuildingBlock.add(18);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.currentBuildingBlock.add(171);
        this.currentBlockSwitches.add(labels.length + 1);
        this.handleLabel();
    }

    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        this.currentBuildingBlock.add(opcode);
    }

    public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
        this.currentBuildingBlock.add(197);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        this.currentBuildingBlock.add(170);
        this.currentBlockSwitches.add(labels.length + 1);
        this.handleLabel();
    }

    public void visitTypeInsn(int opcode, String type) {
        this.currentBuildingBlock.add(opcode);
        if (187 == opcode) {
            this.currentAllocationList.add(type);
        }
    }

    public void visitVarInsn(int opcode, int var) {
        this.currentBuildingBlock.add(opcode);
    }

    private void handleLabel() {
        if (!this.currentBuildingBlock.isEmpty()) {
            this.buildingList.add(new BasicBlock(this.currentBuildingBlock, this.currentBlockSwitches, this.currentAllocationList));
            this.currentBuildingBlock = new ArrayList<Integer>();
            this.currentBlockSwitches = new ArrayList<Integer>();
            this.currentAllocationList = new ArrayList<String>();
        }
    }
}

