/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.instrument;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aion.avm.core.NodeEnvironment;
import org.aion.avm.core.types.ClassInfo;
import org.aion.avm.core.types.Forest;
import org.aion.avm.core.util.DescriptorParser;
import org.aion.avm.utilities.Utilities;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public class HeapMemoryCostCalculator {
    private Map<String, Integer> classHeapSizeMap = new HashMap<String, Integer>();
    private Map<String, Integer> rootHeapSizeMap = new HashMap<String, Integer>();

    public Map<String, Integer> getClassHeapSizeMap() {
        return this.classHeapSizeMap;
    }

    private void calcInstanceSizeOfOneClass(byte[] classBytes) {
        int superClassSize;
        if (this.classHeapSizeMap == null) {
            throw new IllegalStateException("HeapMemoryCostCalculator does not have the classHeapSizeMap.");
        }
        ClassNode classNode = new ClassNode();
        ClassReader cr = new ClassReader(classBytes);
        cr.accept((ClassVisitor)classNode, 2);
        if (this.classHeapSizeMap.containsKey(classNode.name)) {
            return;
        }
        int heapSize = 0;
        if (this.rootHeapSizeMap.containsKey(classNode.superName)) {
            superClassSize = this.rootHeapSizeMap.get(classNode.superName);
        } else if (this.classHeapSizeMap.containsKey(classNode.superName)) {
            superClassSize = this.classHeapSizeMap.get(classNode.superName);
        } else {
            throw new IllegalStateException("A parent class is not processed by HeapMemoryCostCalculator: " + classNode.superName);
        }
        heapSize += superClassSize;
        List fieldNodes = classNode.fields;
        for (FieldNode fieldNode : fieldNodes) {
            if ((fieldNode.access & 8) != 0) continue;
            heapSize = (int)((long)heapSize + (Long)DescriptorParser.parse(fieldNode.desc, new DescriptorParser.TypeOnlyCallbacks<Long>(){

                @Override
                public Long readObject(int arrayDimensions, String type, Long userData) {
                    return FieldTypeSizeInBytes.OBJECTREF.getVal();
                }

                @Override
                public Long readBoolean(int arrayDimensions, Long userData) {
                    return 0 == arrayDimensions ? FieldTypeSizeInBytes.BOOLEAN.getVal() : FieldTypeSizeInBytes.OBJECTREF.getVal();
                }

                @Override
                public Long readShort(int arrayDimensions, Long userData) {
                    return 0 == arrayDimensions ? FieldTypeSizeInBytes.SHORT.getVal() : FieldTypeSizeInBytes.OBJECTREF.getVal();
                }

                @Override
                public Long readLong(int arrayDimensions, Long userData) {
                    return 0 == arrayDimensions ? FieldTypeSizeInBytes.LONG.getVal() : FieldTypeSizeInBytes.OBJECTREF.getVal();
                }

                @Override
                public Long readInteger(int arrayDimensions, Long userData) {
                    return 0 == arrayDimensions ? FieldTypeSizeInBytes.INT.getVal() : FieldTypeSizeInBytes.OBJECTREF.getVal();
                }

                @Override
                public Long readFloat(int arrayDimensions, Long userData) {
                    return 0 == arrayDimensions ? FieldTypeSizeInBytes.FLOAT.getVal() : FieldTypeSizeInBytes.OBJECTREF.getVal();
                }

                @Override
                public Long readDouble(int arrayDimensions, Long userData) {
                    return 0 == arrayDimensions ? FieldTypeSizeInBytes.DOUBLE.getVal() : FieldTypeSizeInBytes.OBJECTREF.getVal();
                }

                @Override
                public Long readChar(int arrayDimensions, Long userData) {
                    return 0 == arrayDimensions ? FieldTypeSizeInBytes.CHAR.getVal() : FieldTypeSizeInBytes.OBJECTREF.getVal();
                }

                @Override
                public Long readByte(int arrayDimensions, Long userData) {
                    return 0 == arrayDimensions ? FieldTypeSizeInBytes.BYTE.getVal() : FieldTypeSizeInBytes.OBJECTREF.getVal();
                }
            }, null));
        }
        this.classHeapSizeMap.put(classNode.name, heapSize);
    }

    public void calcClassesInstanceSize(Forest<String, ClassInfo> classHierarchy) {
        Map<String, Integer> rootClassObjectSizes = NodeEnvironment.singleton.preRenameRuntimeObjectSizeMap;
        Collection<Forest.Node<String, ClassInfo>> rootClasses = classHierarchy.getRoots();
        for (Forest.Node<String, ClassInfo> rootClass : rootClasses) {
            String slashName = Utilities.fullyQualifiedNameToInternalName(rootClass.getId());
            this.rootHeapSizeMap.put(slashName, rootClassObjectSizes.get(slashName));
        }
        Forest.Visitor<String, ClassInfo> visitor = new Forest.Visitor<String, ClassInfo>(){

            @Override
            public void onVisitRoot(Forest.Node<String, ClassInfo> root) {
            }

            @Override
            public void onVisitNotRootNode(Forest.Node<String, ClassInfo> node) {
                HeapMemoryCostCalculator.this.calcInstanceSizeOfOneClass(node.getContent().getBytes());
            }

            @Override
            public void afterAllNodesVisited() {
            }
        };
        classHierarchy.walkPreOrder(visitor);
    }

    public static enum FieldTypeSizeInBytes {
        BYTE(1),
        CHAR(2),
        SHORT(2),
        INT(4),
        LONG(8),
        FLOAT(4),
        DOUBLE(8),
        BOOLEAN(1),
        OBJECTREF(8);

        private final int val;

        private FieldTypeSizeInBytes(int val) {
            this.val = val;
        }

        public long getVal() {
            return this.val;
        }
    }
}

