/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.miscvisitors;

import i.RuntimeAssertionError;
import org.aion.avm.core.miscvisitors.PreRenameClassAccessRules;
import org.aion.avm.core.rejection.RejectedClassException;
import org.aion.avm.core.util.DebugNameResolver;
import org.aion.avm.core.util.DescriptorParser;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;

public class NamespaceMapper {
    private static final String FIELD_PREFIX = "avm_";
    private static final String METHOD_PREFIX = "avm_";
    private final PreRenameClassAccessRules preRenameClassAccessRules;
    private final String shadowPackageSlash;

    public NamespaceMapper(PreRenameClassAccessRules preRenameClassAccessRules) {
        this.preRenameClassAccessRules = preRenameClassAccessRules;
        this.shadowPackageSlash = "s/";
    }

    public static String mapFieldName(String name) {
        return "avm_" + name;
    }

    public static String mapMethodName(String name) {
        if ("<init>".equals(name) || "<clinit>".equals(name)) {
            return name;
        }
        return "avm_" + name;
    }

    public Type mapMethodType(Type type, boolean preserveDebuggability) {
        return Type.getMethodType((String)this.mapDescriptor(type.getDescriptor(), preserveDebuggability));
    }

    public Handle mapHandle(Handle methodHandle, boolean mapMethodDescriptor, boolean preserveDebuggability) {
        String methodOwner = methodHandle.getOwner();
        String methodName = methodHandle.getName();
        String methodDescriptor = methodHandle.getDesc();
        String newMethodOwner = this.mapType(methodOwner, preserveDebuggability);
        String newMethodName = NamespaceMapper.mapMethodName(methodName);
        String newMethodDescriptor = mapMethodDescriptor ? this.mapDescriptor(methodDescriptor, preserveDebuggability) : methodDescriptor;
        return new Handle(methodHandle.getTag(), newMethodOwner, newMethodName, newMethodDescriptor, methodHandle.isInterface());
    }

    public String mapDescriptor(String descriptor, final boolean preserveDebuggability) {
        StringBuilder builder = DescriptorParser.parse(descriptor, new DescriptorParser.Callbacks<StringBuilder>(){

            @Override
            public StringBuilder readObject(int arrayDimensions, String type, StringBuilder userData) {
                this.writeArrayDimensions(userData, arrayDimensions);
                String newType = NamespaceMapper.this.mapType(type, preserveDebuggability);
                userData.append('L');
                userData.append(newType);
                userData.append(';');
                return userData;
            }

            @Override
            public StringBuilder readBoolean(int arrayDimensions, StringBuilder userData) {
                this.writeArrayDimensions(userData, arrayDimensions);
                userData.append('Z');
                return userData;
            }

            @Override
            public StringBuilder readShort(int arrayDimensions, StringBuilder userData) {
                this.writeArrayDimensions(userData, arrayDimensions);
                userData.append('S');
                return userData;
            }

            @Override
            public StringBuilder readLong(int arrayDimensions, StringBuilder userData) {
                this.writeArrayDimensions(userData, arrayDimensions);
                userData.append('J');
                return userData;
            }

            @Override
            public StringBuilder readInteger(int arrayDimensions, StringBuilder userData) {
                this.writeArrayDimensions(userData, arrayDimensions);
                userData.append('I');
                return userData;
            }

            @Override
            public StringBuilder readFloat(int arrayDimensions, StringBuilder userData) {
                this.writeArrayDimensions(userData, arrayDimensions);
                userData.append('F');
                return userData;
            }

            @Override
            public StringBuilder readDouble(int arrayDimensions, StringBuilder userData) {
                this.writeArrayDimensions(userData, arrayDimensions);
                userData.append('D');
                return userData;
            }

            @Override
            public StringBuilder readChar(int arrayDimensions, StringBuilder userData) {
                this.writeArrayDimensions(userData, arrayDimensions);
                userData.append('C');
                return userData;
            }

            @Override
            public StringBuilder readByte(int arrayDimensions, StringBuilder userData) {
                this.writeArrayDimensions(userData, arrayDimensions);
                userData.append('B');
                return userData;
            }

            @Override
            public StringBuilder argumentStart(StringBuilder userData) {
                userData.append('(');
                return userData;
            }

            @Override
            public StringBuilder argumentEnd(StringBuilder userData) {
                userData.append(')');
                return userData;
            }

            @Override
            public StringBuilder readVoid(StringBuilder userData) {
                userData.append('V');
                return userData;
            }

            private void writeArrayDimensions(StringBuilder builder, int dimensions) {
                for (int i = 0; i < dimensions; ++i) {
                    builder.append('[');
                }
            }
        }, new StringBuilder());
        return builder.toString();
    }

    public String[] mapTypeArray(String[] types, boolean preserveDebuggability) {
        String[] newNames = null;
        if (null != types) {
            newNames = new String[types.length];
            for (int i = 0; i < types.length; ++i) {
                newNames[i] = this.mapType(types[i], preserveDebuggability);
            }
        }
        return newNames;
    }

    public String mapType(String type, boolean preserveDebuggability) {
        RuntimeAssertionError.assertTrue(!type.contains("."));
        Object newType = null;
        if (type.startsWith("[")) {
            newType = this.mapDescriptor(type, preserveDebuggability);
        } else if (this.preRenameClassAccessRules.isUserDefinedClassOrInterface(type)) {
            newType = DebugNameResolver.getUserPackageSlashPrefix(type, preserveDebuggability);
        } else if (this.preRenameClassAccessRules.isJclClass(type)) {
            newType = this.shadowPackageSlash + type;
        } else if (this.preRenameClassAccessRules.isApiClass(type)) {
            newType = "p/" + type;
        } else {
            RejectedClassException.notAllowedClass(type);
        }
        return newType;
    }
}

