/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.miscvisitors;

import i.RuntimeAssertionError;
import java.util.Set;
import java.util.stream.Collectors;
import org.aion.avm.core.NodeEnvironment;
import org.aion.avm.utilities.Utilities;
import score.UserRevertException;

public class PreRenameClassAccessRules {
    private static final Set<String> SUBCLASS_ALLOWLIST_SLASH_NAMES = Set.of(Enum.class.getName(), Exception.class.getName(), Object.class.getName(), RuntimeException.class.getName(), Throwable.class.getName(), UserRevertException.class.getName()).stream().map(Utilities::fullyQualifiedNameToInternalName).collect(Collectors.toSet());
    private final Set<String> userDefinedSlashClassesOnly;
    private final Set<String> userDefinedSlashClassesAndInterfaces;

    public PreRenameClassAccessRules(Set<String> preRenameUserDefinedDotClassesOnly, Set<String> preRenameUserDefinedDotClassesAndInterfaces) {
        this.userDefinedSlashClassesOnly = preRenameUserDefinedDotClassesOnly.stream().map(Utilities::fullyQualifiedNameToInternalName).collect(Collectors.toSet());
        this.userDefinedSlashClassesAndInterfaces = preRenameUserDefinedDotClassesAndInterfaces.stream().map(Utilities::fullyQualifiedNameToInternalName).collect(Collectors.toSet());
    }

    public boolean canUserSubclass(String slashName) {
        RuntimeAssertionError.assertTrue(!slashName.contains("."));
        return this.internalIsUserDefinedClassOnly(slashName) || this.internalIsJclSubclassAllowlist(slashName);
    }

    public boolean canUserAccessClass(String slashName) {
        RuntimeAssertionError.assertTrue(!slashName.contains("."));
        return this.internalIsUserDefinedClassOrInterface(slashName) || this.internalIsJclClass(slashName) || this.internalIsArray(slashName) || this.internalIsApiClass(slashName);
    }

    public boolean isUserDefinedClassOrInterface(String slashName) {
        RuntimeAssertionError.assertTrue(!slashName.contains("."));
        return this.internalIsUserDefinedClassOrInterface(slashName);
    }

    public boolean isJclClass(String slashName) {
        RuntimeAssertionError.assertTrue(!slashName.contains("."));
        return this.internalIsJclClass(slashName);
    }

    public boolean isApiClass(String slashName) {
        RuntimeAssertionError.assertTrue(!slashName.contains("."));
        return this.internalIsApiClass(slashName);
    }

    private boolean internalIsUserDefinedClassOnly(String slashName) {
        return this.userDefinedSlashClassesOnly.contains(slashName);
    }

    private boolean internalIsUserDefinedClassOrInterface(String slashName) {
        return this.userDefinedSlashClassesAndInterfaces.contains(slashName);
    }

    private boolean internalIsJclClass(String slashName) {
        return NodeEnvironment.singleton.isClassFromJCL(slashName);
    }

    private boolean internalIsArray(String slashName) {
        return 0 == slashName.indexOf("[");
    }

    private boolean internalIsApiClass(String slashName) {
        return slashName.startsWith("score/");
    }

    private boolean internalIsJclSubclassAllowlist(String slashName) {
        return SUBCLASS_ALLOWLIST_SLASH_NAMES.contains(slashName);
    }
}

