/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.miscvisitors;

import org.aion.avm.core.ClassToolchain;
import org.aion.avm.core.arraywrapping.ArrayNameMapper;
import org.aion.avm.core.miscvisitors.NamespaceMapper;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class UserClassMappingVisitor
extends ClassToolchain.ToolChainClassVisitor {
    private final NamespaceMapper mapper;
    private final boolean preserveDebuggability;

    public UserClassMappingVisitor(NamespaceMapper mapper, boolean preserveDebuggability) {
        super(458752);
        this.mapper = mapper;
        this.preserveDebuggability = preserveDebuggability;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        String newName = this.mapper.mapType(name, this.preserveDebuggability);
        String newSuperName = this.mapper.mapType(superName, this.preserveDebuggability);
        String[] newInterfaces = this.mapper.mapTypeArray(interfaces, this.preserveDebuggability);
        super.visit(version, access, newName, null, newSuperName, newInterfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        String newName = NamespaceMapper.mapMethodName(name);
        String newDescriptor = this.mapper.mapDescriptor(descriptor, this.preserveDebuggability);
        String[] newExceptions = this.mapper.mapTypeArray(exceptions, this.preserveDebuggability);
        MethodVisitor mv = super.visitMethod(access, newName, newDescriptor, null, newExceptions);
        return new MethodVisitor(458752, mv){

            public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                String newOwner = UserClassMappingVisitor.this.mapper.mapType(owner, UserClassMappingVisitor.this.preserveDebuggability);
                String newName = NamespaceMapper.mapMethodName(name);
                String newDescriptor = UserClassMappingVisitor.this.mapper.mapDescriptor(descriptor, UserClassMappingVisitor.this.preserveDebuggability);
                super.visitMethodInsn(opcode, newOwner, newName, newDescriptor, isInterface);
            }

            public void visitTypeInsn(int opcode, String type) {
                super.visitTypeInsn(opcode, UserClassMappingVisitor.this.mapper.mapType(type, UserClassMappingVisitor.this.preserveDebuggability));
            }

            public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
                String newOwner = UserClassMappingVisitor.this.mapper.mapType(owner, UserClassMappingVisitor.this.preserveDebuggability);
                String newName = NamespaceMapper.mapFieldName(name);
                String newDescriptor = UserClassMappingVisitor.this.mapper.mapDescriptor(descriptor, UserClassMappingVisitor.this.preserveDebuggability);
                super.visitFieldInsn(opcode, newOwner, newName, newDescriptor);
            }

            public void visitInvokeDynamicInsn(String methodName, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
                String newName = NamespaceMapper.mapMethodName(methodName);
                String newDescriptor = UserClassMappingVisitor.this.mapper.mapDescriptor(descriptor, UserClassMappingVisitor.this.preserveDebuggability);
                Handle newBootstrapMethodHandle = UserClassMappingVisitor.this.mapper.mapHandle(bootstrapMethodHandle, false, UserClassMappingVisitor.this.preserveDebuggability);
                Object[] newArgs = new Object[bootstrapMethodArguments.length];
                for (int i = 0; i < bootstrapMethodArguments.length; ++i) {
                    Object arg = bootstrapMethodArguments[i];
                    Object newArg = arg instanceof Type ? UserClassMappingVisitor.this.mapper.mapMethodType((Type)arg, UserClassMappingVisitor.this.preserveDebuggability) : (arg instanceof Handle ? UserClassMappingVisitor.this.mapper.mapHandle((Handle)arg, true, UserClassMappingVisitor.this.preserveDebuggability) : arg);
                    newArgs[i] = newArg;
                }
                super.visitInvokeDynamicInsn(newName, newDescriptor, newBootstrapMethodHandle, newArgs);
            }

            public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
                String newDescriptor = UserClassMappingVisitor.this.mapper.mapDescriptor(descriptor, UserClassMappingVisitor.this.preserveDebuggability);
                super.visitMultiANewArrayInsn(newDescriptor, numDimensions);
            }

            public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
                String newType = null != type ? UserClassMappingVisitor.this.mapper.mapType(type, UserClassMappingVisitor.this.preserveDebuggability) : null;
                super.visitTryCatchBlock(start, end, handler, newType);
            }

            public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
                Object[] newLocal = this.getMappedObjects(local);
                Object[] newStack = this.getMappedObjects(stack);
                super.visitFrame(type, nLocal, newLocal, nStack, newStack);
            }

            private Object[] getMappedObjects(Object[] input) {
                Object[] newMapping = new Object[input.length];
                for (int i = 0; i < input.length; ++i) {
                    newMapping[i] = input[i] instanceof String ? UserClassMappingVisitor.this.mapper.mapType((String)input[i], UserClassMappingVisitor.this.preserveDebuggability) : input[i];
                }
                return newMapping;
            }

            public void visitLdcInsn(Object value) {
                Object valueToWrite = value;
                if (value instanceof Type) {
                    if (((Type)value).getSort() == 10) {
                        valueToWrite = Type.getType((String)UserClassMappingVisitor.this.mapper.mapDescriptor(((Type)value).getDescriptor(), UserClassMappingVisitor.this.preserveDebuggability));
                    } else if (((Type)value).getSort() == 9) {
                        valueToWrite = Type.getType((String)("L" + ArrayNameMapper.getPreciseArrayWrapperDescriptor(UserClassMappingVisitor.this.mapper.mapDescriptor(((Type)value).getDescriptor(), UserClassMappingVisitor.this.preserveDebuggability)) + ";"));
                    }
                }
                super.visitLdcInsn(valueToWrite);
            }
        };
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        String newName = NamespaceMapper.mapFieldName(name);
        String newDescriptor = this.mapper.mapDescriptor(descriptor, this.preserveDebuggability);
        return super.visitField(access, newName, newDescriptor, null, value);
    }

    public void visitNestHost(String nestHost) {
        String newHost = this.mapper.mapType(nestHost, this.preserveDebuggability);
        super.visitNestHost(newHost);
    }

    public void visitNestMember(String nestMember) {
        String newMember = this.mapper.mapType(nestMember, this.preserveDebuggability);
        super.visitNestMember(newMember);
    }

    public void visitOuterClass(String owner, String name, String descriptor) {
        String newOwner = this.mapper.mapType(owner, this.preserveDebuggability);
        String newName = NamespaceMapper.mapMethodName(name);
        String newDescriptor = descriptor == null ? null : this.mapper.mapDescriptor(descriptor, this.preserveDebuggability);
        super.visitOuterClass(newOwner, newName, newDescriptor);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        String newName = this.mapper.mapType(name, this.preserveDebuggability);
        String newOuterName = null != outerName ? this.mapper.mapType(outerName, this.preserveDebuggability) : null;
        super.visitInnerClass(newName, newOuterName, innerName, access);
    }
}

