/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.persistence;

import i.RuntimeAssertionError;
import org.aion.avm.core.ClassToolchain;
import org.aion.avm.core.persistence.ConstructorThisInterpreter;
import org.aion.avm.core.persistence.LazyLoadingMethodVisitor;
import org.aion.avm.core.persistence.StackThisTracker;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;

public class AutomaticGraphVisitor
extends ClassToolchain.ToolChainClassVisitor {
    private static final String CLINIT_NAME = "<clinit>";
    private static final String INIT_NAME = "<init>";
    private static final String SPECIAL_CONSTRUCTOR_DESCRIPTOR = "(Ljava/lang/Void;I)V";
    private boolean isInterface;
    private String className;
    private String superClassName;

    public AutomaticGraphVisitor() {
        super(458752);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.isInterface = 0 != (0x200 & access);
        this.className = name;
        this.superClassName = superName;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        int newAccess = 0xFFFFFFEF & access;
        return super.visitField(newAccess, name, descriptor, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        final MethodVisitor downstream = super.visitMethod(access, name, descriptor, signature, exceptions);
        Object visitor = null;
        visitor = CLINIT_NAME.equals(name) ? downstream : (INIT_NAME.equals(name) ? new MethodNode(458752, access, name, descriptor, signature, exceptions){

            public void visitEnd() {
                super.visitEnd();
                Analyzer analyzer = new Analyzer((Interpreter)new ConstructorThisInterpreter());
                try {
                    Frame[] frames = analyzer.analyze(AutomaticGraphVisitor.this.className, (MethodNode)this);
                    StackThisTracker tracker = new StackThisTracker(frames);
                    this.accept(new LazyLoadingMethodVisitor(downstream, tracker));
                }
                catch (AnalyzerException e) {
                    throw RuntimeAssertionError.unexpected(e);
                }
            }
        } : new LazyLoadingMethodVisitor(downstream, null));
        return visitor;
    }

    public void visitEnd() {
        if (!this.isInterface) {
            MethodVisitor methodVisitor = super.visitMethod(1, INIT_NAME, SPECIAL_CONSTRUCTOR_DESCRIPTOR, null, null);
            methodVisitor.visitCode();
            methodVisitor.visitVarInsn(25, 0);
            methodVisitor.visitVarInsn(25, 1);
            methodVisitor.visitVarInsn(21, 2);
            methodVisitor.visitMethodInsn(183, this.superClassName, INIT_NAME, SPECIAL_CONSTRUCTOR_DESCRIPTOR, false);
            methodVisitor.visitInsn(177);
            methodVisitor.visitMaxs(4, 4);
            methodVisitor.visitEnd();
        }
        super.visitEnd();
    }
}

