/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.persistence;

import i.IObjectSerializer;
import i.RuntimeAssertionError;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.IdentityHashMap;
import java.util.Queue;
import org.aion.avm.core.persistence.IGlobalResolver;
import org.aion.avm.core.persistence.IPersistenceNameMapper;
import org.aion.avm.core.persistence.SortedFieldCache;

public class ByteBufferObjectSerializer
implements IObjectSerializer {
    private final ByteBuffer buffer;
    private final SortedFieldCache cache;
    private final IGlobalResolver resolver;
    private final IPersistenceNameMapper classNameMapper;
    private final InstanceIndexMapper instanceMapper;

    public ByteBufferObjectSerializer(ByteBuffer buffer, Queue<Object> out_ToProcessQueue, SortedFieldCache cache, IGlobalResolver resolver, IPersistenceNameMapper classNameMapper) {
        this.buffer = buffer;
        this.cache = cache;
        this.resolver = resolver;
        this.classNameMapper = classNameMapper;
        this.instanceMapper = new InstanceIndexMapper(out_ToProcessQueue);
    }

    @Override
    public void writeBoolean(boolean value) {
        this.buffer.put((byte)(value ? 1 : 0));
    }

    @Override
    public void writeByte(byte value) {
        this.buffer.put(value);
    }

    @Override
    public void writeShort(short value) {
        this.buffer.putShort(value);
    }

    @Override
    public void writeChar(char value) {
        this.buffer.putChar(value);
    }

    @Override
    public void writeInt(int value) {
        this.buffer.putInt(value);
    }

    @Override
    public void writeFloat(float value) {
        this.buffer.putInt(Float.floatToIntBits(value));
    }

    @Override
    public void writeLong(long value) {
        this.buffer.putLong(value);
    }

    @Override
    public void writeDouble(double value) {
        this.buffer.putLong(Double.doubleToLongBits(value));
    }

    @Override
    public void writeByteArray(byte[] value) {
        this.buffer.put(value);
    }

    @Override
    public void writeObject(Object value) {
        if (null == value) {
            this.buffer.put((byte)0);
        } else {
            int constantIdentifier = this.resolver.getAsConstant(value);
            if (0 != constantIdentifier) {
                this.buffer.put((byte)2);
                this.buffer.putInt(constantIdentifier);
            } else {
                String internalClassName = this.resolver.getAsInternalClassName(value);
                if (null != internalClassName) {
                    this.buffer.put((byte)1);
                    this.internalWriteClassName(internalClassName);
                } else {
                    int instanceIndex = this.instanceMapper.getIndexForInstance(value);
                    this.buffer.put((byte)3);
                    this.buffer.putInt(instanceIndex);
                }
            }
        }
    }

    @Override
    public void writeClassName(String internalClassName) {
        this.internalWriteClassName(internalClassName);
    }

    @Override
    public void automaticallySerializeToRoot(Class<?> rootClass, Object instance) {
        this.internalSerializeFieldsToRoot(rootClass, instance.getClass(), instance);
    }

    private void internalSerializeFieldsToRoot(Class<?> rootClass, Class<?> thisClass, Object instance) {
        if (rootClass != thisClass) {
            this.internalSerializeFieldsToRoot(rootClass, thisClass.getSuperclass(), instance);
            try {
                Field[] fields;
                for (Field field : fields = this.cache.getInstanceFields(thisClass)) {
                    Class<?> type = field.getType();
                    if (Boolean.TYPE == type) {
                        boolean val = field.getBoolean(instance);
                        this.writeBoolean(val);
                        continue;
                    }
                    if (Byte.TYPE == type) {
                        byte val = field.getByte(instance);
                        this.writeByte(val);
                        continue;
                    }
                    if (Short.TYPE == type) {
                        short val = field.getShort(instance);
                        this.writeShort(val);
                        continue;
                    }
                    if (Character.TYPE == type) {
                        char val = field.getChar(instance);
                        this.writeChar(val);
                        continue;
                    }
                    if (Integer.TYPE == type) {
                        int val = field.getInt(instance);
                        this.writeInt(val);
                        continue;
                    }
                    if (Float.TYPE == type) {
                        float actual = field.getFloat(instance);
                        this.writeFloat(actual);
                        continue;
                    }
                    if (Long.TYPE == type) {
                        long val = field.getLong(instance);
                        this.writeLong(val);
                        continue;
                    }
                    if (Double.TYPE == type) {
                        double actual = field.getDouble(instance);
                        this.writeDouble(actual);
                        continue;
                    }
                    Object target = field.get(instance);
                    this.writeObject(target);
                }
            }
            catch (IllegalAccessException e) {
                throw RuntimeAssertionError.unexpected(e);
            }
        }
    }

    private void internalWriteClassName(String internalClassName) {
        String storageName = this.classNameMapper.getStorageClassName(internalClassName);
        byte[] utf8 = storageName.getBytes(StandardCharsets.UTF_8);
        RuntimeAssertionError.assertTrue(utf8.length > 0);
        RuntimeAssertionError.assertTrue(utf8.length <= 255);
        this.buffer.put((byte)utf8.length);
        this.buffer.put(utf8);
    }

    private static class InstanceIndexMapper {
        private int nextInstanceIndex = 0;
        private final IdentityHashMap<Object, Integer> instanceToIndex = new IdentityHashMap();
        private final Queue<Object> sharedToProcessQueue;

        public InstanceIndexMapper(Queue<Object> sharedToProcessQueue) {
            this.sharedToProcessQueue = sharedToProcessQueue;
        }

        public int getIndexForInstance(Object instance) {
            Integer indexObject = this.instanceToIndex.get(instance);
            if (null == indexObject) {
                indexObject = this.nextInstanceIndex;
                ++this.nextInstanceIndex;
                this.instanceToIndex.put(instance, indexObject);
                this.sharedToProcessQueue.add(instance);
            }
            return indexObject;
        }
    }
}

