/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.persistence;

import i.RuntimeAssertionError;
import org.aion.avm.core.persistence.StackThisTracker;
import org.aion.avm.utilities.Utilities;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import s.java.lang.Object;

public class LazyLoadingMethodVisitor
extends MethodVisitor {
    private static final String SHADOW_OBJECT_NAME = Utilities.fullyQualifiedNameToInternalName(Object.class.getName());
    private static final String LAZY_LOAD_NAME = "lazyLoad";
    private static final String LAZY_LOAD_DESCRIPTOR = "()V";
    private final StackThisTracker tracker;
    private int frameOffset;

    public LazyLoadingMethodVisitor(MethodVisitor visitor, StackThisTracker tracker) {
        super(458752, visitor);
        this.tracker = tracker;
    }

    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        this.checkInjectLazyLoad(opcode, descriptor);
        super.visitFieldInsn(opcode, owner, name, descriptor);
        ++this.frameOffset;
    }

    public void visitInsn(int opcode) {
        super.visitInsn(opcode);
        ++this.frameOffset;
    }

    public void visitIntInsn(int opcode, int operand) {
        super.visitIntInsn(opcode, operand);
        ++this.frameOffset;
    }

    public void visitVarInsn(int opcode, int var) {
        super.visitVarInsn(opcode, var);
        ++this.frameOffset;
    }

    public void visitTypeInsn(int opcode, String type) {
        super.visitTypeInsn(opcode, type);
        ++this.frameOffset;
    }

    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        ++this.frameOffset;
    }

    public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, java.lang.Object ... bootstrapMethodArguments) {
        super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
        ++this.frameOffset;
    }

    public void visitJumpInsn(int opcode, Label label) {
        super.visitJumpInsn(opcode, label);
        ++this.frameOffset;
    }

    public void visitLdcInsn(java.lang.Object value) {
        super.visitLdcInsn(value);
        ++this.frameOffset;
    }

    public void visitIincInsn(int var, int increment) {
        super.visitIincInsn(var, increment);
        ++this.frameOffset;
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        super.visitTableSwitchInsn(min, max, dflt, labels);
        ++this.frameOffset;
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        super.visitLookupSwitchInsn(dflt, keys, labels);
        ++this.frameOffset;
    }

    public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
        super.visitMultiANewArrayInsn(descriptor, numDimensions);
        ++this.frameOffset;
    }

    public void visitFrame(int type, int nLocal, java.lang.Object[] local, int nStack, java.lang.Object[] stack) {
        super.visitFrame(type, nLocal, local, nStack, stack);
        ++this.frameOffset;
    }

    public void visitLabel(Label label) {
        super.visitLabel(label);
        ++this.frameOffset;
    }

    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
        ++this.frameOffset;
    }

    public void visitEnd() {
        super.visitEnd();
        RuntimeAssertionError.assertTrue(null == this.tracker || this.frameOffset == this.tracker.getFrameCount());
    }

    private void checkInjectLazyLoad(int opcode, String descriptor) {
        if (!(181 != opcode || null != this.tracker && this.tracker.isThisTargetOfPut(this.frameOffset))) {
            if (1 == descriptor.length() && ('J' == descriptor.charAt(0) || 'D' == descriptor.charAt(0))) {
                super.visitInsn(93);
                super.visitInsn(88);
                super.visitInsn(89);
                super.visitMethodInsn(182, SHADOW_OBJECT_NAME, LAZY_LOAD_NAME, LAZY_LOAD_DESCRIPTOR, false);
                super.visitInsn(91);
                super.visitInsn(87);
            } else {
                super.visitInsn(92);
                super.visitInsn(87);
                super.visitMethodInsn(182, SHADOW_OBJECT_NAME, LAZY_LOAD_NAME, LAZY_LOAD_DESCRIPTOR, false);
            }
        } else if (!(180 != opcode || null != this.tracker && this.tracker.isThisTargetOfGet(this.frameOffset))) {
            super.visitInsn(89);
            super.visitMethodInsn(182, SHADOW_OBJECT_NAME, LAZY_LOAD_NAME, LAZY_LOAD_DESCRIPTOR, false);
        }
    }
}

