/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.persistence;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.aion.avm.core.persistence.Deserializer;
import org.aion.avm.core.persistence.IGlobalResolver;
import org.aion.avm.core.persistence.IPersistenceNameMapper;
import org.aion.avm.core.persistence.Serializer;
import org.aion.avm.core.persistence.SortedFieldCache;

public class ReentrantGraph {
    public final byte[] rawState;
    private final List<Object> existingObjectIndex;
    private final List<Integer> calleeToCallerMapping;

    public static ReentrantGraph captureCallerState(IGlobalResolver resolver, SortedFieldCache cache, IPersistenceNameMapper classNameMapper, int maximumSizeInBytes, int nextHashCode, Class<?>[] sortedRoots, Class<?> constantClass) {
        ByteBuffer buffer = ByteBuffer.allocate(maximumSizeInBytes);
        ArrayList<Object> existingObjectIndex = new ArrayList<Object>();
        Serializer.serializeEntireGraphAndNextHashCode(buffer, existingObjectIndex, null, resolver, cache, classNameMapper, nextHashCode, sortedRoots, constantClass);
        byte[] finalBytes = new byte[buffer.position()];
        System.arraycopy(buffer.array(), 0, finalBytes, 0, finalBytes.length);
        return new ReentrantGraph(finalBytes, existingObjectIndex, null);
    }

    public static ReentrantGraph captureCalleeState(IGlobalResolver resolver, SortedFieldCache cache, IPersistenceNameMapper classNameMapper, int maximumSizeInBytes, int nextHashCode, Class<?>[] sortedRoots, Class<?> constantClass) {
        ByteBuffer calleeBuffer = ByteBuffer.allocate(maximumSizeInBytes);
        ArrayList<Integer> calleeToCallerMapping = new ArrayList<Integer>();
        Serializer.serializeEntireGraphAndNextHashCode(calleeBuffer, null, calleeToCallerMapping, resolver, cache, classNameMapper, nextHashCode, sortedRoots, constantClass);
        byte[] calleeBytes = new byte[calleeBuffer.position()];
        System.arraycopy(calleeBuffer.array(), 0, calleeBytes, 0, calleeBytes.length);
        return new ReentrantGraph(calleeBytes, null, calleeToCallerMapping);
    }

    public ReentrantGraph(byte[] rawState, List<Object> existingObjectIndex, List<Integer> calleeToCallerMapping) {
        this.rawState = rawState;
        this.existingObjectIndex = existingObjectIndex;
        this.calleeToCallerMapping = calleeToCallerMapping;
    }

    public int commitChangesToState(IGlobalResolver resolver, SortedFieldCache cache, IPersistenceNameMapper classNameMapper, Class<?>[] sortedRoots, Class<?> constantClass, ReentrantGraph calleeState) {
        ArrayList<Object> updatedIndex = new ArrayList<Object>();
        for (int callerIndex : calleeState.calleeToCallerMapping) {
            Object target = -1 == callerIndex ? null : this.existingObjectIndex.get(callerIndex);
            updatedIndex.add(target);
        }
        ByteBuffer readingBuffer = ByteBuffer.wrap(calleeState.rawState);
        return Deserializer.deserializeEntireGraphAndNextHashCode(readingBuffer, updatedIndex, resolver, cache, classNameMapper, sortedRoots, constantClass);
    }

    public int revertChangesToState(IGlobalResolver resolver, SortedFieldCache cache, IPersistenceNameMapper classNameMapper, Class<?>[] sortedRoots, Class<?> constantClass) {
        ByteBuffer readingBuffer = ByteBuffer.wrap(this.rawState);
        return Deserializer.deserializeEntireGraphAndNextHashCode(readingBuffer, this.existingObjectIndex, resolver, cache, classNameMapper, sortedRoots, constantClass);
    }

    public int applyToRootsForNewFrame(IGlobalResolver resolver, SortedFieldCache cache, IPersistenceNameMapper classNameMapper, Class<?>[] sortedRoots, Class<?> constantClass) {
        ByteBuffer fakeBuffer = ByteBuffer.wrap(this.rawState);
        return Deserializer.deserializeEntireGraphAndNextHashCode(fakeBuffer, null, resolver, cache, classNameMapper, sortedRoots, constantClass);
    }
}

