/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.rejection;

import i.RuntimeAssertionError;
import java.nio.charset.StandardCharsets;
import org.aion.avm.core.ClassToolchain;
import org.aion.avm.core.miscvisitors.NamespaceMapper;
import org.aion.avm.core.miscvisitors.PreRenameClassAccessRules;
import org.aion.avm.core.rejection.RejectedClassException;
import org.aion.avm.core.rejection.RejectionAnnotationVisitor;
import org.aion.avm.core.rejection.RejectionFieldVisitor;
import org.aion.avm.core.rejection.RejectionMethodVisitor;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.ModuleVisitor;
import org.objectweb.asm.TypePath;

public class RejectionClassVisitor
extends ClassToolchain.ToolChainClassVisitor {
    private final PreRenameClassAccessRules preRenameClassAccessRules;
    private final NamespaceMapper namespaceMapper;
    private final boolean preserveDebuggability;

    public RejectionClassVisitor(PreRenameClassAccessRules preRenameClassAccessRules, NamespaceMapper namespaceMapper, boolean preserveDebuggability) {
        super(458752);
        this.preRenameClassAccessRules = preRenameClassAccessRules;
        this.namespaceMapper = namespaceMapper;
        this.preserveDebuggability = preserveDebuggability;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (55 != version) {
            RejectedClassException.unsupportedClassVersion(version);
        }
        if (name.getBytes(StandardCharsets.UTF_8).length > 127) {
            RejectedClassException.nameTooLong(name);
        }
        if (!this.preRenameClassAccessRules.canUserSubclass(superName)) {
            RejectedClassException.restrictedSuperclass(name, superName);
        }
        if (name.startsWith("score/")) {
            RejectedClassException.unsupportedPackageName(name);
        }
        super.visit(version, access, name, null, superName, interfaces);
    }

    public void visitSource(String source, String debug) {
    }

    public ModuleVisitor visitModule(String name, int access, String version) {
        throw RuntimeAssertionError.unimplemented("AKI-106: This is never called");
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        return new RejectionAnnotationVisitor();
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        return new RejectionAnnotationVisitor();
    }

    public void visitAttribute(Attribute attribute) {
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        FieldVisitor fieldVisitor = super.visitField(access, name, descriptor, null, value);
        return new RejectionFieldVisitor(fieldVisitor);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if ("finalize".equals(name)) {
            RejectedClassException.forbiddenMethodOverride(name);
        }
        if (0 != (0x20 & access)) {
            RejectedClassException.invalidMethodFlag(name, "ACC_SYNCHRONIZED");
        }
        MethodVisitor mv = super.visitMethod(access, name, descriptor, null, exceptions);
        return new RejectionMethodVisitor(mv, this.preRenameClassAccessRules, this.namespaceMapper, this.preserveDebuggability);
    }
}

