/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.shadowing;

import i.RuntimeAssertionError;
import java.util.ArrayList;
import org.aion.avm.core.ClassToolchain;
import org.aion.avm.core.miscvisitors.NamespaceMapper;
import org.aion.avm.core.rejection.RejectedClassException;
import org.aion.avm.core.shadowing.IObjectReplacer;
import org.aion.avm.utilities.Utilities;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import s.java.lang.Runnable;
import s.java.util.function.Function;

public class InvokedynamicShadower
extends ClassToolchain.ToolChainClassVisitor {
    private final IObjectReplacer replacer;
    private final String postRenameStringConcatFactory;
    private final String postRenameLambdaFactory;
    private static final String RUNNABLE_DESCRIPTOR = "()L" + Utilities.fullyQualifiedNameToInternalName(Runnable.class.getName()) + ";";
    private static final String FUNCTION_DESCRIPTOR = "()L" + Utilities.fullyQualifiedNameToInternalName(Function.class.getName()) + ";";

    public InvokedynamicShadower(String shadowPackage) {
        super(458752);
        this.replacer = new IObjectReplacer(shadowPackage);
        this.postRenameStringConcatFactory = shadowPackage + "java/lang/invoke/StringConcatFactory";
        this.postRenameLambdaFactory = shadowPackage + "java/lang/invoke/LambdaMetafactory";
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, descriptor, null, exceptions);
        return new IndyMethodVisitor(mv);
    }

    private final class IndyMethodVisitor
    extends MethodVisitor {
        private IndyMethodVisitor(MethodVisitor methodVisitor) {
            super(458752, methodVisitor);
        }

        public void visitInvokeDynamicInsn(String origMethodName, String methodDescriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
            String methodOwner = bootstrapMethodHandle.getOwner();
            if (this.isStringConcatIndy(methodOwner, origMethodName)) {
                this.handleStringConcatIndy(origMethodName, methodDescriptor, bootstrapMethodHandle, bootstrapMethodArguments);
            } else if (this.isLambdaIndy(methodOwner)) {
                if (!methodDescriptor.startsWith("()")) {
                    throw RejectedClassException.invokeDynamicBootstrapMethodArguments(methodDescriptor);
                }
                if (!RUNNABLE_DESCRIPTOR.equals(methodDescriptor) && !FUNCTION_DESCRIPTOR.equals(methodDescriptor)) {
                    throw RejectedClassException.invokeDynamicLambdaType(methodDescriptor);
                }
                if (bootstrapMethodHandle.getTag() != 5 && bootstrapMethodHandle.getTag() != 6 && bootstrapMethodHandle.getTag() != 8 && bootstrapMethodHandle.getTag() != 9) {
                    throw RejectedClassException.invokeDynamicHandleType(bootstrapMethodHandle.getTag(), methodDescriptor);
                }
                this.handleLambdaIndy(origMethodName, methodDescriptor, bootstrapMethodHandle, bootstrapMethodArguments);
            } else {
                throw RejectedClassException.invokeDynamicUnsupportedMethodOwner(origMethodName, methodOwner);
            }
        }

        private boolean isStringConcatIndy(String owner, String origMethodName) {
            return InvokedynamicShadower.this.postRenameStringConcatFactory.equals(owner) && NamespaceMapper.mapMethodName("makeConcatWithConstants").equals(origMethodName);
        }

        private boolean isLambdaIndy(String owner) {
            return InvokedynamicShadower.this.postRenameLambdaFactory.equals(owner);
        }

        private void handleLambdaIndy(String origMethodName, String methodDescriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
            String newMethodName = origMethodName;
            String newMethodDescriptor = InvokedynamicShadower.this.replacer.replaceMethodDescriptor(methodDescriptor);
            Handle newHandle = this.newLambdaHandleFrom(bootstrapMethodHandle, false);
            Object[] newBootstrapMethodArgs = this.newShadowLambdaArgsFrom(bootstrapMethodArguments);
            super.visitInvokeDynamicInsn(newMethodName, newMethodDescriptor, newHandle, newBootstrapMethodArgs);
        }

        private void handleStringConcatIndy(String origMethodName, String methodDescriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
            RuntimeAssertionError.assertTrue("avm_makeConcatWithConstants".equals(origMethodName));
            String newMethodDescriptor = InvokedynamicShadower.this.replacer.replaceMethodDescriptor(methodDescriptor);
            Handle newHandle = this.newLambdaHandleFrom(bootstrapMethodHandle, false);
            super.visitInvokeDynamicInsn(origMethodName, newMethodDescriptor, newHandle, bootstrapMethodArguments);
        }

        private Handle newLambdaHandleFrom(Handle origHandle, boolean shadowMethodDescriptor) {
            String owner;
            String newOwner = owner = origHandle.getOwner();
            String newMethodName = origHandle.getName();
            String newMethodDescriptor = shadowMethodDescriptor ? InvokedynamicShadower.this.replacer.replaceMethodDescriptor(origHandle.getDesc()) : origHandle.getDesc();
            return new Handle(origHandle.getTag(), newOwner, newMethodName, newMethodDescriptor, origHandle.isInterface());
        }

        private Object[] newShadowLambdaArgsFrom(Object[] origArgs) {
            ArrayList<Type> newArgs = new ArrayList<Type>(origArgs.length);
            for (Object origArg : origArgs) {
                Object newArg = origArg instanceof Type ? this.newMethodTypeFrom((Type)origArg) : (origArg instanceof Handle ? this.newLambdaHandleFrom((Handle)origArg, true) : origArg);
                newArgs.add((Type)newArg);
            }
            return newArgs.toArray();
        }

        private Type newMethodTypeFrom(Type origType) {
            return Type.getMethodType((String)InvokedynamicShadower.this.replacer.replaceMethodDescriptor(origType.getDescriptor()));
        }
    }
}

