/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.types;

import i.RuntimeAssertionError;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.aion.avm.core.ClassRenamer;
import org.aion.avm.core.types.ClassInformation;
import org.aion.avm.core.types.ClassInformationRenamer;
import org.aion.avm.core.types.CommonType;
import org.aion.avm.core.types.DecoratedHierarchyNode;
import org.aion.avm.core.types.HierarchyGhostNode;
import org.aion.avm.core.types.HierarchyNode;
import org.aion.avm.core.types.IHierarchyNode;

public final class ClassHierarchy {
    private final DecoratedHierarchyNode root;
    private Map<String, DecoratedHierarchyNode> nameToNodeMapping = new HashMap<String, DecoratedHierarchyNode>();
    private Set<String> preRenameUserDefinedClasses = null;

    public ClassHierarchy() {
        HierarchyNode javaLangObjectNode = HierarchyNode.from(ClassInformation.postRenameInfofrom(CommonType.JAVA_LANG_OBJECT));
        HierarchyNode IObjectNode = HierarchyNode.from(ClassInformation.postRenameInfofrom(CommonType.I_OBJECT));
        HierarchyNode shadowObjectNode = HierarchyNode.from(ClassInformation.postRenameInfofrom(CommonType.SHADOW_OBJECT));
        HierarchyNode javaLangThrowable = HierarchyNode.from(ClassInformation.postRenameInfofrom(CommonType.JAVA_LANG_THROWABLE));
        this.connectChildAndParent(IObjectNode, javaLangObjectNode);
        this.connectChildAndParent(shadowObjectNode, IObjectNode);
        this.connectChildAndParent(javaLangThrowable, javaLangObjectNode);
        this.root = DecoratedHierarchyNode.decorate(javaLangObjectNode);
        this.nameToNodeMapping.put(this.root.getDotName(), this.root);
        this.nameToNodeMapping.put(IObjectNode.getDotName(), DecoratedHierarchyNode.decorate(IObjectNode));
        this.nameToNodeMapping.put(shadowObjectNode.getDotName(), DecoratedHierarchyNode.decorate(shadowObjectNode));
        this.nameToNodeMapping.put(javaLangThrowable.getDotName(), DecoratedHierarchyNode.decorate(javaLangThrowable));
    }

    public void addPreRenameUserDefinedClasses(ClassRenamer classRenamer, Set<ClassInformation> preRenameUserDefinedClassInfos) {
        RuntimeAssertionError.assertTrue(this.preRenameUserDefinedClasses == null);
        this.preRenameUserDefinedClasses = new HashSet<String>();
        for (ClassInformation classInformation : preRenameUserDefinedClassInfos) {
            this.preRenameUserDefinedClasses.add(classInformation.dotName);
        }
        if (classRenamer.preserveDebuggability) {
            HashSet<ClassInformation> authoritativeUserDefinedClassSet = new HashSet<ClassInformation>();
            for (ClassInformation classInfo : preRenameUserDefinedClassInfos) {
                String superClass = classInfo.superClassDotName;
                String[] superInterfaces = classInfo.getInterfaces();
                boolean superIsObject = superClass != null && superClass.equals(CommonType.JAVA_LANG_OBJECT.dotName);
                String string = superClass = superIsObject ? null : superClass;
                if (superClass != null) {
                    superClass = !this.preRenameUserDefinedClasses.contains(superClass) ? classRenamer.toPostRenameOrRejectClass(superClass, ClassRenamer.ArrayType.NOT_ARRAY) : superClass;
                }
                for (int i = 0; i < superInterfaces.length; ++i) {
                    superInterfaces[i] = !this.preRenameUserDefinedClasses.contains(superInterfaces[i]) ? classRenamer.toPostRenameOrRejectClass(superInterfaces[i], ClassRenamer.ArrayType.NOT_ARRAY) : superInterfaces[i];
                }
                if (classInfo.isInterface && superInterfaces.length == 0) {
                    authoritativeUserDefinedClassSet.add(ClassInformation.postRenameInfoFor(classInfo.isInterface, classInfo.dotName, superClass, new String[]{CommonType.I_OBJECT.dotName}));
                    continue;
                }
                authoritativeUserDefinedClassSet.add(ClassInformation.postRenameInfoFor(classInfo.isInterface, classInfo.dotName, superClass, superInterfaces));
            }
            for (ClassInformation authoritativeUserDefinedClass : authoritativeUserDefinedClassSet) {
                this.add(authoritativeUserDefinedClass);
            }
        } else {
            for (ClassInformation classInformation : preRenameUserDefinedClassInfos) {
                this.add(ClassInformationRenamer.toPostRenameClassInfo(classRenamer, classInformation));
            }
        }
    }

    public boolean postRenameTypeIsInterface(String className) {
        if (className.equals(CommonType.JAVA_LANG_OBJECT.dotName) || className.equals(CommonType.JAVA_LANG_THROWABLE.dotName)) {
            return false;
        }
        RuntimeAssertionError.assertTrue(this.nameToNodeMapping.containsKey(className));
        return this.nameToNodeMapping.get((Object)className).getClassInfo().isInterface;
    }

    public String getConcreteSuperClassDotName(String className) {
        RuntimeAssertionError.assertTrue(this.nameToNodeMapping.containsKey(className));
        return this.nameToNodeMapping.get((Object)className).getClassInfo().superClassDotName;
    }

    public boolean isPreRenameUserDefinedClass(String className) {
        if (this.preRenameUserDefinedClasses == null) {
            return false;
        }
        return this.preRenameUserDefinedClasses.contains(className);
    }

    public Set<String> getPreRenameUserDefinedClassesAndInterfaces() {
        return this.preRenameUserDefinedClasses == null ? Collections.emptySet() : new HashSet<String>(this.preRenameUserDefinedClasses);
    }

    public boolean isDescendantOfClass(String descendant, String superClass) {
        RuntimeAssertionError.assertTrue(this.nameToNodeMapping.containsKey(descendant));
        RuntimeAssertionError.assertTrue(this.nameToNodeMapping.containsKey(superClass));
        LinkedList<String> nodesToVisit = new LinkedList<String>();
        nodesToVisit.add(superClass);
        while (!nodesToVisit.isEmpty()) {
            DecoratedHierarchyNode nextNode = this.nameToNodeMapping.get(nodesToVisit.poll());
            for (IHierarchyNode child : nextNode.getChildren()) {
                nodesToVisit.add(child.getDotName());
            }
            if (!nextNode.getDotName().equals(descendant)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String dotName) {
        return this.nameToNodeMapping.containsKey(dotName);
    }

    public Set<String> getPreRenameUserDefinedClassesOnly(ClassRenamer classRenamer) {
        HashSet<String> classes = new HashSet<String>();
        if (this.preRenameUserDefinedClasses == null) {
            return classes;
        }
        for (String className : this.preRenameUserDefinedClasses) {
            String classNameForQuery = classRenamer.toPostRename(className, ClassRenamer.ArrayType.NOT_ARRAY);
            if (this.nameToNodeMapping.get((Object)classNameForQuery).getClassInfo().isInterface) continue;
            classes.add(className);
        }
        return classes;
    }

    public String getTightestCommonSuperClass(String class1, String class2) {
        if (class1 == null || class2 == null) {
            throw new NullPointerException("Cannot get the tightest super class of a null class: " + class1 + ", " + class2);
        }
        if (!this.nameToNodeMapping.containsKey(class1)) {
            throw new IllegalArgumentException("The hierarchy does not contain: " + class1);
        }
        if (!this.nameToNodeMapping.containsKey(class2)) {
            throw new IllegalArgumentException("The hierarchy does not contain: " + class2);
        }
        this.visitAncestorsAndMarkGreen(class1);
        this.visitAncestorsAndMarkRed(class2);
        Set<ClassInformation> leafNodes = this.discoverAllDoublyMarkedLeafNodesFromRoot();
        this.clearAllMarkings();
        RuntimeAssertionError.assertTrue(!leafNodes.isEmpty());
        if (leafNodes.size() > 1) {
            return null;
        }
        RuntimeAssertionError.assertTrue(leafNodes.size() == 1);
        return leafNodes.iterator().next().dotName;
    }

    HierarchyNode getRoot() {
        return this.root.unwrapRealNode();
    }

    public int size() {
        return this.nameToNodeMapping.size();
    }

    public ClassHierarchy deepCopy() {
        ClassHierarchy deepCopy = new ClassHierarchy();
        Set<ClassInformation> classInfos = this.getClassInfosOfAllNodes();
        for (ClassInformation classInfo : classInfos) {
            if (classInfo.dotName.equals(CommonType.JAVA_LANG_OBJECT.dotName) || classInfo.dotName.equals(CommonType.I_OBJECT.dotName) || classInfo.dotName.equals(CommonType.SHADOW_OBJECT.dotName) || classInfo.dotName.equals(CommonType.JAVA_LANG_THROWABLE.dotName)) continue;
            deepCopy.add(classInfo);
        }
        deepCopy.preRenameUserDefinedClasses = this.preRenameUserDefinedClasses == null ? null : new HashSet<String>(this.preRenameUserDefinedClasses);
        return deepCopy;
    }

    public void addIfAbsent(ClassInformation classToAdd) {
        if (classToAdd == null) {
            throw new NullPointerException("Cannot add a null node to the hierarchy.");
        }
        DecoratedHierarchyNode node = this.nameToNodeMapping.get(classToAdd.dotName);
        if (node == null || node.isGhostNode()) {
            this.add(classToAdd);
        }
    }

    public void add(ClassInformation classToAdd) {
        String[] superClasses;
        RuntimeAssertionError.assertTrue(classToAdd != null);
        RuntimeAssertionError.assertTrue(!classToAdd.isPreRenameClassInfo);
        RuntimeAssertionError.assertTrue(!classToAdd.dotName.contains("/"));
        HierarchyNode newNode = HierarchyNode.from(classToAdd);
        DecoratedHierarchyNode nodeToAddFoundInMap = this.nameToNodeMapping.get(classToAdd.dotName);
        if (nodeToAddFoundInMap == null) {
            this.nameToNodeMapping.put(newNode.getDotName(), DecoratedHierarchyNode.decorate(newNode));
        } else if (nodeToAddFoundInMap.isGhostNode()) {
            this.replaceGhostNodeWithRealNode(nodeToAddFoundInMap.unwrapGhostNode(), newNode);
        } else {
            throw new IllegalArgumentException("Attempted to re-add a node: " + classToAdd.dotName);
        }
        for (String superClass : superClasses = classToAdd.superClasses()) {
            if (superClass.equals(CommonType.JAVA_LANG_OBJECT.dotName)) {
                this.nameToNodeMapping.remove(classToAdd.dotName);
                throw new IllegalArgumentException("Attempted to subclass " + CommonType.JAVA_LANG_OBJECT.dotName + " in a post-rename hierarchy: " + classToAdd.dotName);
            }
            DecoratedHierarchyNode parentNode = this.nameToNodeMapping.get(superClass);
            if (parentNode == null) {
                DecoratedHierarchyNode ghost = DecoratedHierarchyNode.decorate(new HierarchyGhostNode(superClass));
                this.nameToNodeMapping.put(ghost.getDotName(), ghost);
                parentNode = ghost;
            }
            parentNode.addChild(newNode);
            newNode.addParent(parentNode.unwrap());
        }
    }

    private Set<ClassInformation> getClassInfosOfAllNodes() {
        HashSet<ClassInformation> classInfos = new HashSet<ClassInformation>();
        for (DecoratedHierarchyNode node : this.nameToNodeMapping.values()) {
            RuntimeAssertionError.assertTrue(!node.isGhostNode());
            classInfos.add(node.getClassInfo());
        }
        return classInfos;
    }

    private void visitAncestorsAndMarkGreen(String startingNode) {
        this.visitAncestors(startingNode, true);
    }

    private void visitAncestorsAndMarkRed(String startingNode) {
        this.visitAncestors(startingNode, false);
    }

    private Set<ClassInformation> discoverAllDoublyMarkedLeafNodesFromRoot() {
        RuntimeAssertionError.assertTrue(this.root.isMarkedGreen() && this.root.isMarkedRed());
        LinkedList<String> nodesToVisit = new LinkedList<String>();
        nodesToVisit.add(this.root.getDotName());
        HashSet<ClassInformation> leafNodes = new HashSet<ClassInformation>();
        while (!nodesToVisit.isEmpty()) {
            DecoratedHierarchyNode nextNode = this.nameToNodeMapping.get(nodesToVisit.poll());
            boolean foundChild = false;
            for (IHierarchyNode child : nextNode.getChildren()) {
                DecoratedHierarchyNode decoratedChild = this.nameToNodeMapping.get(child.getDotName());
                if (!decoratedChild.isMarkedGreen() || !decoratedChild.isMarkedRed()) continue;
                foundChild = true;
                nodesToVisit.add(child.getDotName());
            }
            if (foundChild) continue;
            leafNodes.add(nextNode.getClassInfo());
        }
        return leafNodes;
    }

    private void clearAllMarkings() {
        for (DecoratedHierarchyNode node : this.nameToNodeMapping.values()) {
            node.clearMarkings();
        }
    }

    private void replaceGhostNodeWithRealNode(HierarchyGhostNode ghostNode, HierarchyNode realNode) {
        RuntimeAssertionError.assertTrue(ghostNode.getDotName().equals(realNode.getDotName()));
        this.nameToNodeMapping.put(realNode.getDotName(), DecoratedHierarchyNode.decorate(realNode));
        for (IHierarchyNode child : ghostNode.getChildren()) {
            realNode.addChild(child);
            child.addParent(realNode);
            child.removeParent(ghostNode);
        }
    }

    private void visitAncestors(String startingNode, boolean markGreen) {
        LinkedList<String> nodesToVisit = new LinkedList<String>();
        nodesToVisit.add(startingNode);
        while (!nodesToVisit.isEmpty()) {
            String next = (String)nodesToVisit.poll();
            DecoratedHierarchyNode nextNode = this.nameToNodeMapping.get(next);
            if (markGreen) {
                nextNode.markGreen();
            } else {
                nextNode.markRed();
            }
            for (IHierarchyNode child : nextNode.getParents()) {
                nodesToVisit.add(child.getDotName());
            }
        }
    }

    private void connectChildAndParent(IHierarchyNode child, IHierarchyNode parent) {
        child.addParent(parent);
        parent.addChild(child);
    }

    public String toString() {
        return "ClassHierarchy { post-rename hierarchy of " + this.nameToNodeMapping.size() + " classes. }";
    }
}

