/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.types;

import i.RuntimeAssertionError;
import org.aion.avm.core.types.ClassInformation;
import org.aion.avm.utilities.Utilities;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;

public class ClassInfoVisitor
extends ClassVisitor {
    private ClassInformation classInfo;
    private final boolean isRenamed;

    public ClassInfoVisitor(boolean isRenamed) {
        super(458752);
        this.isRenamed = isRenamed;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        String parentQualifiedName = superName == null ? null : Utilities.internalNameToFullyQualifiedName(superName);
        String[] interfaceQualifiedNames = ClassInfoVisitor.toQualifiedNames(interfaces);
        boolean isInterface = 512 == (access & 0x200);
        this.classInfo = this.isRenamed ? ClassInformation.postRenameInfoFor(isInterface, Utilities.internalNameToFullyQualifiedName(name), parentQualifiedName, interfaceQualifiedNames) : ClassInformation.preRenameInfoFor(isInterface, Utilities.internalNameToFullyQualifiedName(name), parentQualifiedName, interfaceQualifiedNames);
    }

    public void visitSource(String source, String debug) {
        super.visitSource(source, debug);
    }

    public void visitAttribute(Attribute attribute) {
        super.visitAttribute(attribute);
    }

    public ClassInformation getClassInfo() {
        RuntimeAssertionError.assertTrue(this.classInfo != null);
        return this.classInfo;
    }

    private static String[] toQualifiedNames(String[] classNames) {
        if (classNames == null) {
            return null;
        }
        String[] qualifiedNames = new String[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            qualifiedNames[i] = Utilities.internalNameToFullyQualifiedName(classNames[i]);
        }
        return qualifiedNames;
    }
}

