/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.types;

import i.RuntimeAssertionError;
import java.util.Set;
import org.aion.avm.core.types.ClassInformation;
import org.aion.avm.core.types.HierarchyGhostNode;
import org.aion.avm.core.types.HierarchyNode;
import org.aion.avm.core.types.IHierarchyNode;

public class DecoratedHierarchyNode
implements IHierarchyNode {
    private IHierarchyNode node;
    private boolean isGreen;
    private boolean isRed;

    private DecoratedHierarchyNode(IHierarchyNode node) {
        if (node == null) {
            throw new NullPointerException("Cannot decorate a null node.");
        }
        RuntimeAssertionError.assertTrue(!(node instanceof DecoratedHierarchyNode));
        this.node = node;
        this.isGreen = false;
        this.isRed = false;
    }

    public static DecoratedHierarchyNode decorate(IHierarchyNode node) {
        return new DecoratedHierarchyNode(node);
    }

    public IHierarchyNode unwrap() {
        return this.node;
    }

    public HierarchyNode unwrapRealNode() {
        return (HierarchyNode)this.node;
    }

    public HierarchyGhostNode unwrapGhostNode() {
        return (HierarchyGhostNode)this.node;
    }

    public void markGreen() {
        this.isGreen = true;
    }

    public void markRed() {
        this.isRed = true;
    }

    public boolean isMarkedGreen() {
        return this.isGreen;
    }

    public boolean isMarkedRed() {
        return this.isRed;
    }

    public void clearMarkings() {
        this.isGreen = false;
        this.isRed = false;
    }

    @Override
    public boolean isGhostNode() {
        return this.node.isGhostNode();
    }

    @Override
    public ClassInformation getClassInfo() {
        return this.node.getClassInfo();
    }

    @Override
    public String getDotName() {
        return this.node.getDotName();
    }

    @Override
    public void addChild(IHierarchyNode node) {
        RuntimeAssertionError.assertTrue(!(node instanceof DecoratedHierarchyNode));
        this.node.addChild(node);
    }

    @Override
    public void addParent(IHierarchyNode node) {
        RuntimeAssertionError.assertTrue(!(node instanceof DecoratedHierarchyNode));
        this.node.addParent(node);
    }

    @Override
    public void removeParent(IHierarchyNode node) {
        RuntimeAssertionError.assertTrue(!(node instanceof DecoratedHierarchyNode));
        this.node.removeParent(node);
    }

    @Override
    public Set<IHierarchyNode> getParents() {
        return this.node.getParents();
    }

    @Override
    public Set<IHierarchyNode> getChildren() {
        return this.node.getChildren();
    }

    public String toString() {
        return "DecoratedHierarchyNode { decorating: " + this.node + " }";
    }
}

