/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.types;

import i.RuntimeAssertionError;
import java.util.HashSet;
import java.util.Set;
import org.aion.avm.core.types.ClassInformation;
import org.aion.avm.core.types.DecoratedHierarchyNode;
import org.aion.avm.core.types.IHierarchyNode;

public class HierarchyNode
implements IHierarchyNode {
    private final ClassInformation classInfo;
    private Set<IHierarchyNode> parents;
    private Set<IHierarchyNode> children;

    private HierarchyNode(ClassInformation classInfo) {
        if (classInfo == null) {
            throw new NullPointerException("Cannot construct node from null class info.");
        }
        this.classInfo = classInfo;
        this.parents = new HashSet<IHierarchyNode>();
        this.children = new HashSet<IHierarchyNode>();
    }

    public static HierarchyNode from(ClassInformation classInfo) {
        return new HierarchyNode(classInfo);
    }

    @Override
    public void addChild(IHierarchyNode node) {
        if (node == null) {
            throw new NullPointerException("Cannot add pointer to null child node.");
        }
        RuntimeAssertionError.assertTrue(!(node instanceof DecoratedHierarchyNode));
        this.children.add(node);
    }

    @Override
    public void addParent(IHierarchyNode node) {
        if (node == null) {
            throw new NullPointerException("Cannot add pointer to null parent node.");
        }
        RuntimeAssertionError.assertTrue(!(node instanceof DecoratedHierarchyNode));
        this.parents.add(node);
    }

    @Override
    public void removeParent(IHierarchyNode node) {
        if (node == null) {
            throw new NullPointerException("Cannot remove pointer to null parent node.");
        }
        RuntimeAssertionError.assertTrue(!(node instanceof DecoratedHierarchyNode));
        this.parents.remove(node);
    }

    @Override
    public Set<IHierarchyNode> getParents() {
        return new HashSet<IHierarchyNode>(this.parents);
    }

    @Override
    public Set<IHierarchyNode> getChildren() {
        return new HashSet<IHierarchyNode>(this.children);
    }

    @Override
    public String getDotName() {
        return this.classInfo.dotName;
    }

    @Override
    public ClassInformation getClassInfo() {
        return this.classInfo;
    }

    @Override
    public boolean isGhostNode() {
        return false;
    }

    public String toString() {
        return "HierarchyNode { " + this.classInfo.rawString() + " }";
    }

    public boolean equals(Object other) {
        if (!(other instanceof HierarchyNode)) {
            return false;
        }
        return this.classInfo.equals(((HierarchyNode)other).classInfo);
    }

    public int hashCode() {
        return this.classInfo.hashCode();
    }
}

