/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.util;

import i.CommonInstrumentation;
import i.Helper;
import i.IBlockchainRuntime;
import i.IRuntimeSetup;
import i.RuntimeAssertionError;
import i.StackWatcher;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aion.avm.core.ClassToolchain;
import org.aion.avm.core.classloading.AvmClassLoader;
import org.aion.avm.core.miscvisitors.ClassRenameVisitor;
import org.aion.avm.utilities.Utilities;
import org.objectweb.asm.ClassWriter;
import p.score.Context;

public class Helpers {
    private static final char[] hexArray = "0123456789abcdef".toCharArray();
    private static String contextRuntimeClassName = Context.class.getName();
    private static byte[] contextRuntimeBytes = Utilities.loadRequiredResourceAsBytes(contextRuntimeClassName.replaceAll("\\.", "/") + ".class");

    public static String bytesToHexString(byte[] bytes) {
        if (bytes.length == 0) {
            return "void";
        }
        int length = bytes.length;
        char[] hexChars = new char[length * 2];
        for (int i = 0; i < length; ++i) {
            int v = bytes[i] & 0xFF;
            hexChars[i * 2] = hexArray[v >>> 4];
            hexChars[i * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] hexStringToBytes(String s) {
        if (s.startsWith("0x")) {
            s = s.substring(2);
        }
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static void writeBytesToFile(byte[] bytes, String path) {
        File f = new File(path);
        f.getParentFile().mkdirs();
        try (FileOutputStream fos = new FileOutputStream(f);){
            fos.write(bytes);
        }
        catch (IOException e) {
            throw RuntimeAssertionError.unexpected(e);
        }
    }

    public static Map<String, byte[]> mapIncludingHelperBytecode(Map<String, byte[]> inputMap, byte[] helperBytes) {
        byte[] renamedBytes = new ClassToolchain.Builder(helperBytes, 6).addNextVisitor(new ClassRenameVisitor("H")).addWriter(new ClassWriter(3)).build().runAndGetBytecode();
        HashMap<String, byte[]> modifiedMap = new HashMap<String, byte[]>(inputMap);
        modifiedMap.put("H", renamedBytes);
        modifiedMap.put(contextRuntimeClassName, contextRuntimeBytes);
        return modifiedMap;
    }

    public static byte[] loadDefaultHelperBytecode() {
        String helperName = Helper.class.getName();
        String helperResourcePath = Utilities.fullyQualifiedNameToInternalName(helperName) + ".class";
        return Utilities.loadRequiredResourceAsBytes(helperResourcePath);
    }

    public static void attachBlockchainRuntime(AvmClassLoader contractLoader, IBlockchainRuntime rt) {
        try {
            String runtimeClassName = Context.class.getName();
            Class<?> helperClass = contractLoader.loadClass(runtimeClassName);
            helperClass.getField("blockchainRuntime").set(null, rt);
        }
        catch (Throwable t) {
            throw RuntimeAssertionError.unexpected(t);
        }
    }

    public static void attachStackWatcher(AvmClassLoader contractLoader, StackWatcher stackWatcher) {
        try {
            Class<?> helperClass = contractLoader.loadClass("H");
            Field targetField = helperClass.getDeclaredField("target");
            targetField.setAccessible(true);
            Field currentFrameField = contractLoader.loadClass(CommonInstrumentation.class.getName()).getDeclaredField("currentFrame");
            currentFrameField.setAccessible(true);
            Field stackWatcherField = contractLoader.loadClass(CommonInstrumentation.FrameState.class.getName()).getDeclaredField("stackWatcher");
            stackWatcherField.setAccessible(true);
            stackWatcherField.set(currentFrameField.get(targetField.get(null)), stackWatcher);
        }
        catch (Throwable t) {
            throw RuntimeAssertionError.unexpected(t);
        }
    }

    public static List<Class<?>> getAlphabeticalUserTransformedDappClasses(AvmClassLoader classLoader, Set<String> classNames) {
        ArrayList<String> nameList = new ArrayList<String>(classNames);
        Collections.sort(nameList);
        ArrayList classList = new ArrayList();
        for (String name : nameList) {
            try {
                classList.add(classLoader.loadClass(name));
            }
            catch (ClassNotFoundException e) {
                RuntimeAssertionError.unexpected(e);
            }
        }
        return classList;
    }

    public static IRuntimeSetup getSetupForLoader(ClassLoader loader) {
        try {
            String helperClassName = "H";
            Class<?> clazz = loader.loadClass(helperClassName);
            RuntimeAssertionError.assertTrue(clazz.getClassLoader() == loader);
            return (IRuntimeSetup)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw RuntimeAssertionError.unexpected(e);
        }
    }
}

