/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.utilities.analyze;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aion.avm.utilities.analyze.ByteReader;
import org.aion.avm.utilities.analyze.ConstantType;

public class ClassFileInfoBuilder {
    public static ClassFileInfo getClassFileInfo(byte[] classFile) {
        try {
            return ClassFileInfoBuilder.internalClassFileInfo(classFile);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static ClassFileInfo getDirectClassFileInfo(byte[] classFile) {
        return ClassFileInfoBuilder.internalClassFileInfo(classFile);
    }

    private static ClassFileInfo internalClassFileInfo(byte[] classFile) {
        HashMap<String, Integer> constantTypeCount = new HashMap<String, Integer>();
        int totalUtf8Length = 0;
        int codeIndex = -1;
        ByteReader reader = new ByteReader(classFile);
        reader.readU4();
        reader.readU2();
        reader.readU2();
        int constantPoolCount = reader.readU2() - 1;
        for (int i = 0; i < constantPoolCount; ++i) {
            byte tag = reader.readU1();
            ConstantType constantType = ConstantType.forTag(tag);
            try {
                switch (constantType) {
                    case CONSTANT_CLASS: 
                    case CONSTANT_METHOD_TYPE: 
                    case CONSTANT_STRING: {
                        reader.readU2();
                        break;
                    }
                    case CONSTANT_DOUBLE: 
                    case CONSTANT_LONG: {
                        reader.readU4();
                        reader.readU4();
                        ++i;
                        break;
                    }
                    case CONSTANT_FIELDREF: 
                    case CONSTANT_METHODREF: 
                    case CONSTANT_NAME_AND_TYPE: 
                    case CONSTANT_INVOKE_DYNAMIC: 
                    case CONSTANT_INTERFACE_METHODREF: {
                        reader.readU2();
                        reader.readU2();
                        break;
                    }
                    case CONSTANT_INTEGER: 
                    case CONSTANT_FLOAT: {
                        reader.readU4();
                        break;
                    }
                    case CONSTANT_UTF8: {
                        short length = reader.readU2();
                        totalUtf8Length += length;
                        byte[] raw = reader.readNBytes(length);
                        if (!"Code".equals(new String(raw))) break;
                        codeIndex = i;
                        break;
                    }
                    case CONSTANT_METHOD_HANDLE: {
                        reader.readU1();
                        reader.readU2();
                    }
                }
            }
            catch (Exception e) {
                throw new AssertionError((Object)("Could not find constant pool tag " + tag));
            }
            constantTypeCount.put(constantType.name, constantTypeCount.getOrDefault(constantType.name, 0) + 1);
        }
        int constantPoolByteSize = reader.position();
        reader.readU2();
        reader.readU2();
        reader.readU2();
        int interfaceCount = reader.readU2();
        for (int i = 0; i < interfaceCount; ++i) {
            reader.readU2();
        }
        int fieldCount = reader.readU2();
        int instanceFieldCount = 0;
        for (int i = 0; i < fieldCount; ++i) {
            boolean isInstance = ClassFileInfoBuilder.readFieldInfo(reader);
            if (!isInstance) continue;
            ++instanceFieldCount;
        }
        int methodCount = reader.readU2();
        ArrayList<MethodCode> definedMethods = new ArrayList<MethodCode>();
        for (int i = 0; i < methodCount; ++i) {
            MethodCode method = ClassFileInfoBuilder.readMethodInfo(reader, codeIndex + 1);
            if (null == method) continue;
            definedMethods.add(method);
        }
        int attributeCount = reader.readU2();
        for (int i = 0; i < attributeCount; ++i) {
            ClassFileInfoBuilder.readAttributeInfo(reader, -1);
        }
        return new ClassFileInfo(classFile.length, constantPoolCount, constantTypeCount, totalUtf8Length, constantPoolByteSize, instanceFieldCount, definedMethods);
    }

    private static boolean readFieldInfo(ByteReader reader) {
        short flags = reader.readU2();
        reader.readU2();
        reader.readU2();
        int attributeCount = reader.readU2();
        for (int i = 0; i < attributeCount; ++i) {
            ClassFileInfoBuilder.readAttributeInfo(reader, -1);
        }
        boolean isStatic = 8 == (flags | 8);
        return !isStatic;
    }

    private static MethodCode readMethodInfo(ByteReader reader, int codeIndex) {
        MethodCode implementedMethod = null;
        reader.readU2();
        reader.readU2();
        reader.readU2();
        int attributeCount = reader.readU2();
        for (int i = 0; i < attributeCount; ++i) {
            MethodCode code = ClassFileInfoBuilder.readAttributeInfo(reader, codeIndex);
            if (null == code) continue;
            if (null != implementedMethod) {
                throw new IllegalArgumentException("Multiple code attributes found for the same method");
            }
            implementedMethod = code;
        }
        return implementedMethod;
    }

    private static MethodCode readAttributeInfo(ByteReader reader, int codeAttributeNameIndex) {
        MethodCode code = null;
        short attributeNameIndex = reader.readU2();
        int attributeLength = reader.readU4();
        int start = reader.position();
        if (codeAttributeNameIndex == attributeNameIndex) {
            short max_stack = reader.readU2();
            short max_locals = reader.readU2();
            int code_length = reader.readU4();
            reader.readNBytes(code_length);
            int exception_table_length = reader.readU2();
            for (int i = 0; i < exception_table_length; ++i) {
                reader.readU2();
                reader.readU2();
                reader.readU2();
                reader.readU2();
            }
            int attributeCount = reader.readU2();
            for (int i = 0; i < attributeCount; ++i) {
                ClassFileInfoBuilder.readAttributeInfo(reader, -1);
            }
            code = new MethodCode(max_stack, max_locals, code_length, exception_table_length);
        } else {
            reader.readNBytes(attributeLength);
        }
        int end = reader.position();
        if (end - start != attributeLength) {
            throw new IllegalArgumentException("Declared attribute length and walked attribute length differ");
        }
        return code;
    }

    public static class MethodCode {
        public final int maxStack;
        public final int maxLocals;
        public final int codeLength;
        public final int exceptionTableSize;

        public MethodCode(int maxStack, int maxLocals, int codeLength, int exceptionTableSize) {
            this.maxStack = maxStack;
            this.maxLocals = maxLocals;
            this.codeLength = codeLength;
            this.exceptionTableSize = exceptionTableSize;
        }
    }

    public static class ClassFileInfo {
        public final int classFileLength;
        public final int constantPoolEntryCount;
        public final Map<String, Integer> constantTypeCount;
        public final int totalUtf8ByteLength;
        public final int totalConstantPoolByteSize;
        public final int instanceFieldCount;
        public final List<MethodCode> definedMethods;

        public ClassFileInfo(int classFileLength, int constantPoolEntryCount, Map<String, Integer> constantTypeCount, int totalUtf8ByteLength, int totalConstantPoolByteSize, int instanceFieldCount, List<MethodCode> definedMethods) {
            this.classFileLength = classFileLength;
            this.constantPoolEntryCount = constantPoolEntryCount;
            this.constantTypeCount = Collections.unmodifiableMap(constantTypeCount);
            this.totalUtf8ByteLength = totalUtf8ByteLength;
            this.totalConstantPoolByteSize = totalConstantPoolByteSize;
            this.instanceFieldCount = instanceFieldCount;
            this.definedMethods = Collections.unmodifiableList(definedMethods);
        }
    }
}

