/*
 * Decompiled with CFR 0.152.
 */
package p.score;

import i.CodecIdioms;
import i.IObject;
import i.IObjectDeserializer;
import i.IObjectSerializer;
import i.RuntimeAssertionError;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleInfo;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import s.java.lang.Boolean;
import s.java.lang.Byte;
import s.java.lang.Float;
import s.java.lang.Integer;
import s.java.lang.Short;
import s.java.util.function.Function;

public final class InternalFunction
extends s.java.lang.Object
implements Function {
    private static final String METHOD_PREFIX = "avm_";
    private static final String INIT_NAME = "<init>";
    private Class<?> receiver;
    private String methodName;
    private Class<?> parameterType;
    private Executable target;

    public static InternalFunction createFunction(MethodHandles.Lookup lookup, MethodHandle target) {
        TypeDescriptor.OfField parameterType;
        MethodHandleInfo info = lookup.revealDirect(target);
        Class<?> receiver = info.getDeclaringClass();
        String methodName = info.getName();
        MethodType type = info.getMethodType();
        if (info.getReferenceKind() == 6 || info.getReferenceKind() == 8) {
            parameterType = type.parameterType(0);
        } else if (info.getReferenceKind() == 5 || info.getReferenceKind() == 9) {
            parameterType = null;
        } else {
            throw RuntimeAssertionError.unimplemented("Unexpected MethodType " + info.getReferenceKind());
        }
        RuntimeAssertionError.assertTrue(methodName.startsWith(METHOD_PREFIX) || methodName.equals(INIT_NAME));
        return new InternalFunction(receiver, methodName, (Class<?>)parameterType);
    }

    private InternalFunction(Class<?> receiver, String methodName, Class<?> parameterType) {
        super(null, null, 0);
        this.receiver = receiver;
        this.methodName = methodName;
        this.parameterType = parameterType;
        this.target = InternalFunction.createAccessibleMethod(receiver, methodName, parameterType);
    }

    public InternalFunction(Void ignore, int readIndex) {
        super(ignore, readIndex);
    }

    @Override
    public void deserializeSelf(Class<?> firstRealImplementation, IObjectDeserializer deserializer) {
        super.deserializeSelf(InternalFunction.class, deserializer);
        Object originalReceiver = deserializer.readObject();
        String externalMethodName = CodecIdioms.deserializeString(deserializer);
        Object originalParameter = deserializer.readObject();
        if (null != originalReceiver) {
            Class receiver = ((s.java.lang.Class)originalReceiver).getRealClass();
            Object methodName = externalMethodName.equals(INIT_NAME) ? externalMethodName : METHOD_PREFIX + externalMethodName;
            Class parameterType = null;
            if (originalParameter != null) {
                parameterType = ((s.java.lang.Class)originalParameter).getRealClass();
            }
            this.receiver = receiver;
            this.methodName = methodName;
            this.parameterType = parameterType;
            this.target = InternalFunction.createAccessibleMethod(receiver, (String)methodName, parameterType);
        }
    }

    @Override
    public void serializeSelf(Class<?> firstRealImplementation, IObjectSerializer serializer) {
        super.serializeSelf(InternalFunction.class, serializer);
        s.java.lang.Class receiverClass = new s.java.lang.Class(this.receiver);
        String methodName = this.methodName.equals(INIT_NAME) ? this.methodName : this.methodName.substring(METHOD_PREFIX.length());
        s.java.lang.Class<?> parameterClass = null;
        if (this.parameterType != null) {
            parameterClass = InternalFunction.getShadowCanonicalType(this.parameterType);
        }
        serializer.writeObject(receiverClass);
        CodecIdioms.serializeString(serializer, methodName);
        serializer.writeObject(parameterClass);
    }

    @Override
    public IObject avm_apply(IObject input) {
        try {
            Object result = this.target instanceof Constructor ? ((Constructor)this.target).newInstance(InternalFunction.mapInputToParameterType(input, this.parameterType)) : (this.parameterType == null ? ((Method)this.target).invoke((Object)input, new Object[0]) : ((Method)this.target).invoke(null, InternalFunction.mapInputToParameterType(input, this.parameterType)));
            return InternalFunction.mapBoxedType(result);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
            throw RuntimeAssertionError.unexpected(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw RuntimeAssertionError.unexpected(cause);
        }
    }

    private static Executable createAccessibleMethod(Class<?> receiver, String methodName, Class<?> parameterType) {
        Executable method = null;
        try {
            method = methodName.equals(INIT_NAME) ? receiver.getConstructor(parameterType) : (parameterType == null ? receiver.getDeclaredMethod(methodName, new Class[0]) : receiver.getDeclaredMethod(methodName, parameterType));
        }
        catch (NoSuchMethodException e) {
            throw RuntimeAssertionError.unexpected(e);
        }
        method.setAccessible(true);
        return method;
    }

    private static s.java.lang.Object mapBoxedType(Object obj) {
        s.java.lang.Object ret = null;
        if (null == obj) {
            ret = null;
        } else if (obj instanceof s.java.lang.Object) {
            ret = (s.java.lang.Object)obj;
        } else {
            Class<?> argClass = obj.getClass();
            if (argClass.equals(java.lang.Short.class)) {
                ret = Short.avm_valueOf((java.lang.Short)obj);
            } else if (argClass.equals(java.lang.Integer.class)) {
                ret = Integer.avm_valueOf((java.lang.Integer)obj);
            } else if (argClass.equals(Long.class)) {
                ret = s.java.lang.Long.avm_valueOf((Long)obj);
            } else if (argClass.equals(java.lang.Float.class)) {
                ret = Float.avm_valueOf(((java.lang.Float)obj).floatValue());
            } else if (argClass.equals(Double.class)) {
                ret = s.java.lang.Double.avm_valueOf((Double)obj);
            } else if (argClass.equals(java.lang.Boolean.class)) {
                ret = Boolean.avm_valueOf((java.lang.Boolean)obj);
            } else if (argClass.equals(java.lang.Byte.class)) {
                ret = Byte.avm_valueOf((java.lang.Byte)obj);
            } else if (argClass.equals(Character.class)) {
                ret = s.java.lang.Character.avm_valueOf(((Character)obj).charValue());
            } else {
                RuntimeAssertionError.unreachable("InternalFunction received an unexpected type " + argClass.getName());
            }
        }
        return ret;
    }

    private static Object mapInputToParameterType(IObject input, Class<?> parameterType) {
        Object ret = null;
        if (!parameterType.isPrimitive()) {
            ret = input;
        } else if (parameterType.equals(java.lang.Short.TYPE)) {
            ret = ((Short)input).getUnderlying();
        } else if (parameterType.equals(java.lang.Integer.TYPE)) {
            ret = ((Integer)input).getUnderlying();
        } else if (parameterType.equals(Long.TYPE)) {
            ret = ((s.java.lang.Long)input).getUnderlying();
        } else if (parameterType.equals(java.lang.Float.TYPE)) {
            ret = java.lang.Float.valueOf(((Float)input).getUnderlying());
        } else if (parameterType.equals(Double.TYPE)) {
            ret = ((s.java.lang.Double)input).getUnderlying();
        } else if (parameterType.equals(java.lang.Boolean.TYPE)) {
            ret = ((Boolean)input).getUnderlying();
        } else if (parameterType.equals(java.lang.Byte.TYPE)) {
            ret = ((Byte)input).getUnderlying();
        } else if (parameterType.equals(Character.TYPE)) {
            ret = Character.valueOf(((s.java.lang.Character)input).getUnderlying());
        } else {
            RuntimeAssertionError.unreachable("InternalFunction received an unexpected type " + parameterType.getName());
        }
        return ret;
    }

    private static s.java.lang.Class<?> getShadowCanonicalType(Class<?> parameterType) {
        s.java.lang.Class<Object> ret = null;
        if (!parameterType.isPrimitive()) {
            ret = new s.java.lang.Class(parameterType);
        } else if (parameterType.equals(java.lang.Short.TYPE)) {
            ret = Short.avm_TYPE;
        } else if (parameterType.equals(java.lang.Integer.TYPE)) {
            ret = Integer.avm_TYPE;
        } else if (parameterType.equals(Long.TYPE)) {
            ret = s.java.lang.Long.avm_TYPE;
        } else if (parameterType.equals(java.lang.Float.TYPE)) {
            ret = Float.avm_TYPE;
        } else if (parameterType.equals(Double.TYPE)) {
            ret = s.java.lang.Double.avm_TYPE;
        } else if (parameterType.equals(java.lang.Boolean.TYPE)) {
            ret = Boolean.avm_TYPE;
        } else if (parameterType.equals(java.lang.Byte.TYPE)) {
            ret = Byte.avm_TYPE;
        } else if (parameterType.equals(Character.TYPE)) {
            ret = s.java.lang.Character.avm_TYPE;
        } else {
            RuntimeAssertionError.unreachable("InternalFunction received an unexpected type " + parameterType.getName());
        }
        return ret;
    }
}

