/*
 * Decompiled with CFR 0.152.
 */
package s.java.lang;

import foundation.icon.ee.util.LogMarker;
import i.IInstrumentation;
import i.IObjectDeserializer;
import i.IObjectSerializer;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.aion.avm.ClassNameExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import s.java.io.Serializable;
import s.java.lang.Object;
import s.java.lang.String;

public class Throwable
extends Object
implements Serializable {
    private String message;
    private Throwable cause;
    private java.lang.String systemMessage = null;
    private StackTraceElement[] stackTrace;

    public Throwable() {
        this((String)null, null);
    }

    public Throwable(String message) {
        this(message, null);
    }

    public Throwable(String message, Throwable cause) {
        this.message = message;
        this.cause = cause;
        this.stackTrace = Thread.currentThread().getStackTrace();
    }

    public Throwable(Throwable cause) {
        this.message = cause == null ? null : cause.internalToString();
        this.cause = cause;
        this.stackTrace = Thread.currentThread().getStackTrace();
    }

    public Throwable(Void ignore, int readIndex) {
        super(ignore, readIndex);
    }

    @Override
    public void deserializeSelf(Class<?> firstRealImplementation, IObjectDeserializer deserializer) {
        super.deserializeSelf(Throwable.class, deserializer);
        this.message = (String)deserializer.readObject();
        this.cause = (Throwable)deserializer.readObject();
    }

    @Override
    public void serializeSelf(Class<?> firstRealImplementation, IObjectSerializer serializer) {
        super.serializeSelf(Throwable.class, serializer);
        serializer.writeObject(this.message);
        serializer.writeObject(this.cause);
    }

    public String avm_getMessage() {
        IInstrumentation.attachedThreadInstrumentation.get().chargeEnergy(100);
        this.lazyLoad();
        return this.message;
    }

    public String avm_getLocalizedMessage() {
        IInstrumentation.attachedThreadInstrumentation.get().chargeEnergy(100);
        this.lazyLoad();
        return this.message;
    }

    public Throwable avm_getCause() {
        IInstrumentation.attachedThreadInstrumentation.get().chargeEnergy(100);
        this.lazyLoad();
        return this.cause;
    }

    public Throwable avm_initCause(Throwable cause) {
        IInstrumentation.attachedThreadInstrumentation.get().chargeEnergy(100);
        this.lazyLoad();
        this.cause = cause;
        return this;
    }

    @Override
    public String avm_toString() {
        IInstrumentation.attachedThreadInstrumentation.get().chargeEnergy(300);
        this.lazyLoad();
        return this.internalToString();
    }

    public void avm_printStackTrace() {
        Set<Throwable> visited = Collections.newSetFromMap(new IdentityHashMap());
        StringBuilder sb = new StringBuilder();
        this.buildStackTraceString(sb, "", visited);
        Logger logger = LoggerFactory.getLogger(Throwable.class);
        logger.trace(LogMarker.Trace, "PRT| {}", (java.lang.Object)sb);
    }

    private void buildStackTraceString(StringBuilder sb, java.lang.String caption, Set<Throwable> visited) {
        if (visited.contains(this)) {
            return;
        }
        visited.add(this);
        sb.append(caption).append(this).append("\n");
        if (this.stackTrace != null) {
            for (StackTraceElement e : this.stackTrace) {
                sb.append("\tat ").append(e).append("\n");
            }
        }
        if (this.cause != null) {
            this.cause.buildStackTraceString(sb, "Caused by: ", visited);
        }
    }

    public void setSystemMessage(java.lang.String message) {
        this.systemMessage = message;
    }

    public void setStackTrace(StackTraceElement[] backtrace) {
        this.stackTrace = backtrace;
    }

    public java.lang.String getMessage() {
        return this.message != null ? this.message.getUnderlying() : null;
    }

    public java.lang.String toString() {
        this.lazyLoad();
        return this.getClass().getName() + ": " + (this.message == null ? "" : this.message) + ": " + (this.systemMessage == null ? "" : this.systemMessage);
    }

    private String internalToString() {
        String s = new String(ClassNameExtractor.getOriginalClassName(this.getClass().getName()));
        return this.message != null ? new String(s + ": " + this.message) : s;
    }

    static {
        IInstrumentation.attachedThreadInstrumentation.get().bootstrapOnly();
    }
}

