/*
 * Decompiled with CFR 0.152.
 */
package fun.hereis.code.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class CollectionUtil {
    public static List<String> pick(Collection collection, Pick pick) {
        ArrayList<String> items = new ArrayList<String>();
        if (collection != null && !collection.isEmpty()) {
            collection.forEach(item -> items.add(pick.pick(item)));
        }
        return items;
    }

    public static Map<String, String> mergeMap(Map<String, String> ... maps) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map<String, String> map : maps) {
            result.putAll(map);
        }
        return result;
    }

    public static String getValue(String key, Map<String, String> map, Map<String, String> defaultMap) {
        String result = map.get(key);
        if (result == null) {
            result = defaultMap.get(key);
        }
        return result;
    }

    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static <K, V> Map<K, V> fromList(List<V> list, Function<V, K> getKey) {
        HashMap map = new HashMap();
        if (CollectionUtil.isEmpty(list)) {
            return map;
        }
        list.forEach(item -> map.put(getKey.apply(item), item));
        return map;
    }

    public static void putIfAbsent(Map<String, String> map, String key, String val) {
        if (map != null && !map.containsKey(key)) {
            map.put(key, val);
        }
    }

    public static interface Pick<T> {
        public String pick(T var1);
    }
}

