/*
 * Decompiled with CFR 0.152.
 */
package fun.hereis.code.utils.cache;

import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import fun.hereis.code.utils.cache.GuavaTicker;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class GuavaCache<V> {
    private Loader<V> loader;
    private LoadingCache<String, V> cache;
    private GuavaTicker ticker;
    private static final String KEY = "CACHE_KEY";
    public static Executor REFRESH_EXECUTOR = new ThreadPoolExecutor(3, 10, 10L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(3), new ThreadFactoryBuilder().setNameFormat("GuavaCache-%d").setDaemon(false).setPriority(5).build(), new ThreadPoolExecutor.CallerRunsPolicy());

    public V get() {
        try {
            return (V)this.cache.get((Object)KEY);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public GuavaTicker getTicker() {
        return this.ticker;
    }

    public void refresh() {
        try {
            this.cache.put((Object)KEY, this.loader.load());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private GuavaCache(LoadingCache<String, V> cache, Loader<V> loader, GuavaTicker ticker) {
        this.cache = cache;
        this.loader = loader;
        this.ticker = ticker;
        this.refresh();
    }

    public static <V> GuavaCache<V> asyncGuavaCache(long refreshAfterMinutes, final Loader<V> loader) {
        GuavaTicker ticker = new GuavaTicker();
        LoadingCache loadingCache = GuavaCache.asyncRefreshCache(refreshAfterMinutes, new CacheLoader<String, V>(){

            public V load(String key) throws Exception {
                return loader.load();
            }
        }, ticker);
        return new GuavaCache<V>(loadingCache, loader, ticker);
    }

    public static <K, V> LoadingCache<K, V> asyncRefreshCache(long refreshAfterMinutes, CacheLoader<K, V> loader) {
        return CacheBuilder.newBuilder().refreshAfterWrite(refreshAfterMinutes, TimeUnit.MINUTES).build(CacheLoader.asyncReloading(loader, (Executor)REFRESH_EXECUTOR));
    }

    public static <K, V> LoadingCache<K, V> asyncRefreshCache(long refreshAfterMinutes, CacheLoader<K, V> loader, Ticker ticker) {
        return CacheBuilder.newBuilder().ticker(ticker).refreshAfterWrite(refreshAfterMinutes, TimeUnit.MINUTES).build(CacheLoader.asyncReloading(loader, (Executor)REFRESH_EXECUTOR));
    }

    public static interface Loader<V> {
        public V load();
    }
}

