/*
 * Decompiled with CFR 0.152.
 */
package id.unum.facade.rest.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import id.unum.protos.externalMessage.v1.ExternalMessage;
import java.lang.reflect.Type;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExternalMessageSerializer
implements JsonSerializer<ExternalMessage> {
    private static final Logger log = LogManager.getLogger(ExternalMessageSerializer.class);

    public JsonElement serialize(ExternalMessage externalMessage, Type type, JsonSerializationContext jsonSerializationContext) {
        try {
            JsonElement output = JsonParser.parseString((String)JsonFormat.printer().omittingInsignificantWhitespace().print((MessageOrBuilder)externalMessage));
            return output.getAsJsonObject();
        }
        catch (InvalidProtocolBufferException e) {
            log.error("Error serializing ExternalMessage: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }
}

