/*
 * Decompiled with CFR 0.152.
 */
package id.unum.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.protobuf.Timestamp;
import id.unum.converter.ProtoToDto;
import id.unum.crossPlatformInterfaces.Encoding;
import id.unum.domain.CredentialOptions;
import id.unum.dto.RegisteredIssuer;
import id.unum.dto.Success;
import id.unum.dto.Unum;
import id.unum.enums.CredentialStatusOptions;
import id.unum.error.UnumError;
import id.unum.facade.rest.Client;
import id.unum.facade.rest.UnumAPIService;
import id.unum.facade.rest.request.RegisterIssuerRequest;
import id.unum.facade.rest.request.UpdateCredentialStatusRequest;
import id.unum.protos.credential.v1.Credential;
import id.unum.protos.credential.v1.CredentialStatus;
import id.unum.protos.credential.v1.EncryptedCredential;
import id.unum.protos.credential.v1.IssueCredentialRequest;
import id.unum.protos.credential.v1.UnsignedCredential;
import id.unum.protos.crypto.v1.EncryptedData;
import id.unum.protos.crypto.v1.KeyPairSet;
import id.unum.protos.crypto.v1.PublicKeyInfo;
import id.unum.protos.didDocument.v1.DidDocument;
import id.unum.protos.issuer.v1.Issuer;
import id.unum.protos.proof.v1.Proof;
import id.unum.service.DidDocService;
import id.unum.service.IssuerServiceInterface;
import id.unum.types.CredentialSubject;
import id.unum.utils.CryptoUtils;
import id.unum.utils.Utils;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import retrofit2.Call;
import retrofit2.Response;

public final class IssuerService
implements IssuerServiceInterface {
    private static final Logger log = LogManager.getLogger(IssuerService.class);
    private final UnumAPIService _unumService;
    private final DidDocService _didDocService;

    public IssuerService(String url) {
        Client client = new Client(url);
        this._unumService = (UnumAPIService)client.getRetrofit().create(UnumAPIService.class);
        this._didDocService = new DidDocService(url);
    }

    @Override
    public Unum<RegisteredIssuer> registerIssuer(String customerUuid, String apiKey) throws UnumError {
        log.info("calling register issuer");
        KeyPairSet keyPairSet = CryptoUtils.generateKeyPairSet(Encoding.BASE58);
        RegisterIssuerRequest request = new RegisterIssuerRequest();
        request.setCustomerUuid(customerUuid);
        request.setPublicKeyInfo(Utils.extractPublicKeyInfo(keyPairSet, Encoding.BASE58));
        Call<Issuer> call = this._unumService.registerIssuer("Bearer " + apiKey, request);
        try {
            Response response = call.execute();
            if (!response.isSuccessful()) {
                String message = response.errorBody() != null ? response.errorBody().string() : "Unknown error";
                log.error("Saas error calling register issuer " + message);
                throw new UnumError(response.errorBody().hashCode(), message);
            }
            Issuer issuer = (Issuer)response.body();
            String newAuthToken = response.headers().get("X-Auth-Token");
            Unum<RegisteredIssuer> result = new Unum<RegisteredIssuer>();
            RegisteredIssuer body = ProtoToDto.convertIssuer(issuer);
            result.setBody(body);
            result.setAuthToken(Utils.handleAuthToken(newAuthToken));
            return result;
        }
        catch (IOException e) {
            log.error("IOException calling register issuer: " + e);
            e.printStackTrace();
            throw new UnumError(500, "Unknown error.");
        }
    }

    @Override
    public Unum<id.unum.types.dto.Credential> issueCredential(String authToken, List<String> types, String issuer, ObjectNode credentialSubject, String signingPrivateKey, String expirationDate) throws UnumError {
        Utils.requireAuth(authToken);
        this.validateIssueCredentialInput(types, issuer, credentialSubject, signingPrivateKey, expirationDate);
        CredentialOptions options = this.constructCredentialOptions(types, issuer, credentialSubject, expirationDate);
        List<String> versions = Utils.getVersionList();
        for (int i = 0; i < versions.size() - 1; ++i) {
        }
        String latestVersion = versions.get(versions.size() - 1);
        UnsignedCredential unsignedCredential = null;
        try {
            unsignedCredential = this.constructUnsignedCredential(options);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw new UnumError(500, e.getMessage());
        }
        Credential credential = this.constructSignedCredential(unsignedCredential, signingPrivateKey);
        try {
            List<EncryptedCredential> encryptedCredentials = this.constructEncryptedCredentials(credential, authToken);
            IssueCredentialRequest request = IssueCredentialRequest.newBuilder().setIssuer(issuer).setCredentialId(credential.getId()).setSubject(credential.getCredentialSubject()).setType(Utils.getCredentialType(credential)).addAllEncryptedCredentials(encryptedCredentials).build();
            Call<Success> call = this._unumService.issueCredential(authToken, request);
            Response response = call.execute();
            if (!response.isSuccessful()) {
                String message = response.errorBody() != null ? response.errorBody().string() : "Unknown error";
                log.error("Saas error creating credential" + message);
                throw new UnumError(response.errorBody().hashCode(), message);
            }
            String newAuthToken = response.headers().get("X-Auth-Token");
            Unum<id.unum.types.dto.Credential> result = new Unum<id.unum.types.dto.Credential>();
            id.unum.types.dto.Credential body = ProtoToDto.convertCredential(credential);
            result.setBody(body);
            result.setAuthToken(Utils.handleAuthToken(newAuthToken));
            return result;
        }
        catch (IOException e) {
            log.error("IOException issuing credentials: " + e.getMessage());
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            e.printStackTrace();
        }
        throw new UnumError(500, "Unknown error issuing credentials.");
    }

    @Override
    public Unum<Success> updateCredentialStatus(String authToken, String credentialId, CredentialStatusOptions status) throws UnumError {
        Utils.requireAuth(authToken);
        this.validateUpdateCredentialStatusInput(credentialId, status);
        UpdateCredentialStatusRequest request = new UpdateCredentialStatusRequest();
        request.setStatus(status.getValue());
        Call<Success> call = this._unumService.updateCredentialStatus(authToken, credentialId, request);
        try {
            Response response = call.execute();
            if (!response.isSuccessful()) {
                String message = response.errorBody() != null ? response.errorBody().string() : "Unknown error";
                log.error("Saas error updating credential status" + message);
                throw new UnumError(response.errorBody().hashCode(), message);
            }
            String newAuthToken = response.headers().get("X-Auth-Token");
            Unum<Success> result = new Unum<Success>();
            result.setBody((Success)response.body());
            result.setAuthToken(Utils.handleAuthToken(newAuthToken));
            return result;
        }
        catch (IOException e) {
            log.error("IOException updating credential status: " + e);
            e.printStackTrace();
            throw new UnumError(500, "Unknown error updating credential status.");
        }
    }

    private void validateUpdateCredentialStatusInput(String credentialId, CredentialStatusOptions status) {
    }

    private List<EncryptedCredential> constructEncryptedCredentials(Credential credential, String authToken) throws NoSuchAlgorithmException {
        log.info("constructing encrypted credentials");
        CredentialSubject credentialSubject = ProtoToDto.convertCredentialSubject(credential.getCredentialSubject());
        String subjectDid = credentialSubject.getId();
        Unum<DidDocument> didDocument = this._didDocService.getDIDDoc(authToken, subjectDid);
        List<PublicKeyInfo> pubKeys = this._didDocService.getKeysFromDIDDoc(didDocument.getBody(), "RSA");
        if (pubKeys.isEmpty()) {
            throw new UnumError(404, "Public key not found for the DID");
        }
        ArrayList<EncryptedCredential> result = new ArrayList<EncryptedCredential>();
        for (PublicKeyInfo key : pubKeys) {
            String subjectDidWithKeyFragment = subjectDid + "#" + key.getId();
            EncryptedData encryptedData = CryptoUtils.encrypt(subjectDid, key, credential.toByteArray());
            EncryptedCredential encryptedCredential = EncryptedCredential.newBuilder().setCredentialId(credential.getId()).setSubject(subjectDidWithKeyFragment).setData(encryptedData).setIssuer(credential.getIssuer()).setType(Utils.getCredentialType(credential)).build();
            result.add(encryptedCredential);
        }
        return result;
    }

    private Credential constructSignedCredential(UnsignedCredential unsignedCredential, String privateKey) {
        byte[] bytes = unsignedCredential.toByteArray();
        Proof proof = CryptoUtils.createProof(bytes, privateKey, unsignedCredential.getIssuer(), "SHA256withDSA");
        Credential credential = Credential.newBuilder().addAllContext((Iterable)unsignedCredential.getContextList()).setCredentialStatus(unsignedCredential.getCredentialStatus()).setCredentialSubject(unsignedCredential.getCredentialSubject()).setIssuer(unsignedCredential.getIssuer()).addAllType((Iterable)unsignedCredential.getTypeList()).setId(unsignedCredential.getId()).setIssuanceDate(unsignedCredential.getIssuanceDate()).setExpirationDate(unsignedCredential.getExpirationDate()).setProof(proof).build();
        return credential;
    }

    private UnsignedCredential constructUnsignedCredential(CredentialOptions options) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        String credentialSubjectJson = mapper.writeValueAsString((Object)options.getCredentialSubject());
        String credentialId = UUID.randomUUID().toString();
        options.getType().add(0, "VerifiableCredential");
        CredentialStatus status = CredentialStatus.newBuilder().setType("CredentialStatus").setId(credentialId).build();
        Date now = new Date();
        Instant instant = now.toInstant();
        UnsignedCredential result = UnsignedCredential.newBuilder().addContext("https://www.w3.org/2018/credentials/v1").setCredentialStatus(status).setCredentialSubject(credentialSubjectJson).setIssuer(options.getIssuer()).addAllType(options.getType()).setId(credentialId).setIssuanceDate(Timestamp.newBuilder().build()).setExpirationDate(Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build()).build();
        return result;
    }

    private CredentialOptions constructCredentialOptions(List<String> types, String issuer, ObjectNode credentialSubject, String expirationDate) {
        List<String> filteredTypes = types.stream().filter(type -> !Objects.equals(type, "VerifiableCredential")).collect(Collectors.toList());
        CredentialOptions options = CredentialOptions.builder().credentialSubject(credentialSubject).issuer(issuer).type(filteredTypes).expirationDate(expirationDate).build();
        return options;
    }

    private void validateIssueCredentialInput(List<String> types, String issuer, ObjectNode credentialSubject, String signingPrivateKey, String expirationDate) throws UnumError {
    }
}

