/*
 * Decompiled with CFR 0.152.
 */
package id.unum.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.gson.JsonObject;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.JsonFormat;
import com.google.protobuf.util.Timestamps;
import id.unum.converter.DtoToProto;
import id.unum.converter.ProtoToDto;
import id.unum.crossPlatformInterfaces.Encoding;
import id.unum.dto.DecryptedPresentation;
import id.unum.dto.RegisteredVerifier;
import id.unum.dto.Success;
import id.unum.dto.Unum;
import id.unum.enums.CredentialStatusOptions;
import id.unum.enums.PresentationTypes;
import id.unum.error.UnumError;
import id.unum.facade.rest.Client;
import id.unum.facade.rest.UnumAPIService;
import id.unum.facade.rest.request.RegisterVerifierRequest;
import id.unum.facade.rest.request.SendMessageRequest;
import id.unum.protos.credential.v1.Credential;
import id.unum.protos.credential.v1.CredentialStatusInfo;
import id.unum.protos.credential.v1.UnsignedCredential;
import id.unum.protos.crypto.v1.EncryptedData;
import id.unum.protos.crypto.v1.KeyPair;
import id.unum.protos.crypto.v1.KeyPairSet;
import id.unum.protos.crypto.v1.PublicKeyInfo;
import id.unum.protos.didDocument.v1.DidDocument;
import id.unum.protos.externalMessage.v1.ExternalMessage;
import id.unum.protos.presentation.v1.Presentation;
import id.unum.protos.presentation.v1.UnsignedPresentation;
import id.unum.protos.presentationRequest.v1.UnsignedPresentationRequest;
import id.unum.protos.presentationRequestEnriched.v1.PresentationRequestEnriched;
import id.unum.protos.presentationRequestEnriched.v1.PresentationRequestRepoDto;
import id.unum.protos.proof.v1.Proof;
import id.unum.protos.receipt.v1.PresentationVerifedReceiptOptions;
import id.unum.protos.receipt.v1.Receipt;
import id.unum.protos.receipt.v1.Verified;
import id.unum.protos.verifier.v1.Verifier;
import id.unum.service.DidDocService;
import id.unum.service.DidDocServiceInterface;
import id.unum.service.ReceiptService;
import id.unum.service.ReceiptServiceInterface;
import id.unum.service.VerifierServiceInterface;
import id.unum.types.CredentialSubject;
import id.unum.types.VerifiedStatus;
import id.unum.types.dto.CredentialRequest;
import id.unum.types.dto.PresentationRequest;
import id.unum.types.dto.VersionInfo;
import id.unum.utils.CryptoUtils;
import id.unum.utils.Utils;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import retrofit2.Call;
import retrofit2.Response;

public class VerifierService
implements VerifierServiceInterface {
    private static final Logger log = LogManager.getLogger(VerifierService.class);
    private UnumAPIService _unumService;
    private DidDocServiceInterface _didDocService;
    private ReceiptServiceInterface _receiptService;

    public VerifierService(String url) {
        Client client = new Client(url);
        this._unumService = (UnumAPIService)client.getRetrofit().create(UnumAPIService.class);
        this._didDocService = new DidDocService(url);
        this._receiptService = new ReceiptService(url);
    }

    @Override
    public Unum<RegisteredVerifier> registerVerifier(String customerUuid, String url, String apiKey, List<VersionInfo> versionInfoList) throws UnumError {
        log.info("calling register verifier");
        KeyPairSet keyPairSet = CryptoUtils.generateKeyPairSet(Encoding.PEM);
        RegisterVerifierRequest request = new RegisterVerifierRequest();
        request.setCustomerUuid(customerUuid);
        request.setPublicKeyInfo(Utils.extractPublicKeyInfo(keyPairSet, Encoding.PEM));
        request.setUrl(url);
        request.setVersionInfo(versionInfoList);
        Call<Verifier> call = this._unumService.registerVerifier("Bearer " + apiKey, request);
        try {
            Response response = call.execute();
            if (!response.isSuccessful()) {
                String message = response.errorBody() != null ? response.errorBody().string() : "Unknown error";
                log.error("Saas error calling register verifier " + message);
                throw new UnumError(response.errorBody().hashCode(), message);
            }
            Verifier verifier = (Verifier)response.body();
            String newAuthToken = response.headers().get("X-Auth-Token");
            RegisteredVerifier body = ProtoToDto.convertVerifier(verifier);
            Unum<RegisteredVerifier> result = new Unum<RegisteredVerifier>();
            result.setBody(body);
            result.setAuthToken(Utils.handleAuthToken(newAuthToken));
            return result;
        }
        catch (IOException e) {
            log.error("IOException calling register verifier: " + e.toString());
            e.printStackTrace();
            throw new UnumError(500, "Unknown error registering verifier.");
        }
    }

    @Override
    public Unum<id.unum.types.dto.PresentationRequestEnriched> sendRequest(String authToken, String verifier, List<CredentialRequest> credentialRequests, String signingPrivateKey, String holderAppUuid, Date expiresAt, JsonObject metadata) throws UnumError {
        Utils.requireAuth(authToken);
        this.validateSendRequestInput(verifier, credentialRequests, signingPrivateKey, holderAppUuid);
        String id = UUID.randomUUID().toString();
        List<String> versions = Utils.getVersionList();
        for (int i = 0; i < versions.size() - 1; ++i) {
        }
        String latestVersion = versions.get(versions.size() - 1);
        try {
            UnsignedPresentationRequest unsignedPresentationRequest = this.constructUnsignedPresentationRequest(verifier, credentialRequests, holderAppUuid, expiresAt, metadata, id, latestVersion);
            id.unum.protos.presentationRequest.v1.PresentationRequest signedPresentationRequest = this.constructSignedPresentationRequest(unsignedPresentationRequest, signingPrivateKey);
            Call<PresentationRequestEnriched> call = this._unumService.sendRequest(authToken, signedPresentationRequest);
            Response response = call.execute();
            if (!response.isSuccessful()) {
                String message = response.errorBody() != null ? response.errorBody().string() : "Unknown error";
                log.error("Saas error creating presentation request" + message);
                throw new UnumError(response.errorBody().hashCode(), message);
            }
            String newAuthToken = response.headers().get("X-Auth-Token");
            Unum<id.unum.types.dto.PresentationRequestEnriched> result = new Unum<id.unum.types.dto.PresentationRequestEnriched>();
            result.setBody(ProtoToDto.convertPresentationRequestEnriched((PresentationRequestEnriched)response.body()));
            result.setAuthToken(Utils.handleAuthToken(newAuthToken));
            return result;
        }
        catch (InvalidProtocolBufferException e) {
            e.printStackTrace();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            log.error("IOException creating presentation request: " + e.toString());
            e.printStackTrace();
        }
        throw new UnumError(500, "Unknown error creating presentation request.");
    }

    private id.unum.protos.presentationRequest.v1.PresentationRequest constructSignedPresentationRequest(UnsignedPresentationRequest unsignedPresentationRequest, String signingPrivateKey) {
        byte[] bytes = unsignedPresentationRequest.toByteArray();
        Proof proof = CryptoUtils.createProof(bytes, signingPrivateKey, unsignedPresentationRequest.getVerifier(), "SHA256withECDSA");
        id.unum.protos.presentationRequest.v1.PresentationRequest result = id.unum.protos.presentationRequest.v1.PresentationRequest.newBuilder().setCreatedAt(unsignedPresentationRequest.getCreatedAt()).setUpdatedAt(unsignedPresentationRequest.getUpdatedAt()).setExpiresAt(unsignedPresentationRequest.getExpiresAt()).addAllCredentialRequests((Iterable)unsignedPresentationRequest.getCredentialRequestsList()).setId(unsignedPresentationRequest.getId()).setUuid(unsignedPresentationRequest.getUuid()).setVerifier(unsignedPresentationRequest.getVerifier()).setHolderAppUuid(unsignedPresentationRequest.getHolderAppUuid()).setMetadata(unsignedPresentationRequest.getMetadata()).setVersion(unsignedPresentationRequest.getVersion()).setProof(proof).build();
        return result;
    }

    private UnsignedPresentationRequest constructUnsignedPresentationRequest(String verifier, List<CredentialRequest> credentialRequests, String holderAppUuid, Date expiresAt, JsonObject metadata, String id, String version) throws InvalidProtocolBufferException, JsonProcessingException {
        String uuid = UUID.randomUUID().toString();
        Timestamp now = Timestamp.newBuilder().build();
        Instant time = Instant.now();
        Timestamp tenMinutesFromNow = Timestamp.newBuilder().setSeconds(time.getEpochSecond() + 600L).setNanos(0).build();
        Timestamp end = expiresAt == null ? tenMinutesFromNow : Timestamps.fromMillis((long)expiresAt.getTime());
        UnsignedPresentationRequest result = UnsignedPresentationRequest.newBuilder().setCreatedAt(now).setUpdatedAt(now).setExpiresAt(end).setVerifier(verifier).setUuid(uuid).setId(id).setVersion(version).addAllCredentialRequests(DtoToProto.convertCredentialsToProtos(credentialRequests)).setHolderAppUuid(holderAppUuid).setMetadata(metadata != null ? metadata.toString() : "{}").build();
        return result;
    }

    @Override
    public Unum<DecryptedPresentation> verifyPresentation(String authToken, id.unum.types.EncryptedData encryptedPresentationDto, String verifierDid, String encryptionPrivateKey, id.unum.types.dto.PresentationRequestEnriched presentationRequestEnriched) throws UnumError {
        Utils.requireAuth(authToken);
        try {
            EncryptedData encryptedPresentation = DtoToProto.convertEncryptedDataToProto(encryptedPresentationDto);
            KeyPair keyPair = KeyPair.newBuilder().setPrivateKey(encryptionPrivateKey).build();
            this.validateVerifyPresentationInput(encryptedPresentation, verifierDid, keyPair, presentationRequestEnriched);
            byte[] presentationBytes = CryptoUtils.decrypt(keyPair, encryptedPresentation);
            Presentation presentation = Presentation.parseFrom((byte[])presentationBytes);
            this.validatePresentation(presentation);
            if (presentationRequestEnriched != null && presentationRequestEnriched.getPresentationRequest().getId() != presentation.getPresentationRequestId()) {
                throw new UnumError(400, "Presentation request id provided, " + presentationRequestEnriched.getPresentationRequest().getId() + ", does not match the presentationRequestId that the presentation was in response to. " + presentation.getPresentationRequestId() + ".");
            }
            id.unum.protos.presentationRequest.v1.PresentationRequest presentationRequest = null;
            if (presentationRequestEnriched != null) {
                presentationRequest = this.validatePresentationRequest(presentationRequestEnriched.getPresentationRequest());
            } else if (!presentation.getPresentationRequestId().isEmpty()) {
                Unum<PresentationRequestRepoDto> presentationRequestRepoDto = this.getPresentationRequest(authToken, presentation.getPresentationRequestId());
                authToken = presentationRequestRepoDto.getAuthToken();
                presentationRequest = this.extractPresentationRequest(presentationRequestRepoDto.getBody());
            }
            if (presentationRequest != null) {
                Unum<VerifiedStatus> requestVerificationResult = this.verifyPresentationRequest(authToken, presentationRequest);
                authToken = requestVerificationResult.getAuthToken();
                if (!requestVerificationResult.getBody().isVerified()) {
                    PresentationTypes type = Utils.isDeclinedPresentation(presentation) ? PresentationTypes.DeclinedPresentation : PresentationTypes.VerifiablePresentation;
                    DecryptedPresentation body = new DecryptedPresentation();
                    body.setPresentation(ProtoToDto.convertPresentation(presentation));
                    body.setType(type);
                    body.setVerified(false);
                    body.setMessage(requestVerificationResult.getBody().getMessage());
                    Unum<DecryptedPresentation> result = new Unum<DecryptedPresentation>();
                    result.setAuthToken(Utils.handleAuthToken(authToken));
                    result.setBody(body);
                    return result;
                }
            }
            if (Utils.isDeclinedPresentation(presentation)) {
                Unum<VerifiedStatus> verificationResult = this.verifyDeclinedPresentationHelper(authToken, presentation, verifierDid);
                DecryptedPresentation body = new DecryptedPresentation();
                body.setPresentation(ProtoToDto.convertPresentation(presentation));
                body.setType(PresentationTypes.DeclinedPresentation);
                body.setVerified(verificationResult.getBody().isVerified());
                body.setMessage(verificationResult.getBody().getMessage());
                Unum<DecryptedPresentation> result = new Unum<DecryptedPresentation>();
                result.setAuthToken(Utils.handleAuthToken(verificationResult.getAuthToken()));
                result.setBody(body);
            }
            List credentialRequests = presentationRequest.getCredentialRequestsList();
            Unum<VerifiedStatus> verificationResult = this.verifyPresentationHelper(authToken, presentation, verifierDid, credentialRequests);
            DecryptedPresentation body = new DecryptedPresentation();
            body.setPresentation(ProtoToDto.convertPresentation(presentation));
            body.setType(PresentationTypes.VerifiablePresentation);
            body.setVerified(verificationResult.getBody().isVerified());
            body.setMessage(verificationResult.getBody().getMessage());
            Unum<DecryptedPresentation> result = new Unum<DecryptedPresentation>();
            result.setAuthToken(Utils.handleAuthToken(verificationResult.getAuthToken()));
            result.setBody(body);
            return result;
        }
        catch (InvalidProtocolBufferException e) {
            log.error("Protobuff Error decoding byte array to Presentation object: " + e.getMessage());
            e.printStackTrace();
            throw new UnumError(500, "Error decoding byte array to Presentation object: " + e.getMessage());
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            log.error("Json Error decoding byte array to Presentation object: " + e.getMessage());
            throw new UnumError(500, "Error decoding byte array to Presentation object: " + e.getMessage());
        }
    }

    private id.unum.protos.presentationRequest.v1.PresentationRequest extractPresentationRequest(PresentationRequestRepoDto presentationRequestRepoDto) {
        try {
            PresentationRequestEnriched presentationRequestEnriched = (PresentationRequestEnriched)presentationRequestRepoDto.getPresentationRequestsMap().get("3.0.0");
            return presentationRequestEnriched.getPresentationRequest();
        }
        catch (Exception e) {
            throw new UnumError(500, "Error handling presentation request from Saas: Error " + e);
        }
    }

    private Unum<VerifiedStatus> verifyPresentationHelper(String authToken, Presentation presentation, String verifierDid, List<id.unum.protos.credential.v1.CredentialRequest> credentialRequests) throws InvalidProtocolBufferException {
        Utils.requireAuth(authToken);
        this.validateVerifiablePresentation(presentation);
        if (presentation.getVerifiableCredentialCount() == 0) {
            log.error("The presentation has undefined verifiableCredential attribute, this should have already be checked.");
            throw new UnumError(500, "presentation as an undefined verifiableCredentials");
        }
        if (!credentialRequests.isEmpty()) {
            this.validatePresentationMeetsRequestedCredentials(presentation, credentialRequests);
        }
        Unum<VerifiedStatus> presentationResult = this.verifyPresentationProof(authToken, presentation, verifierDid);
        boolean areCredentialsValid = true;
        for (Credential credential : presentation.getVerifiableCredentialList()) {
            boolean isStatusValid;
            boolean isExpired = Utils.isCredentialExpired(credential);
            if (isExpired) {
                areCredentialsValid = false;
                break;
            }
            Unum<id.unum.dto.CredentialStatusInfo> credentialStatusInfo = this.checkCredentialStatus(authToken, credential.getId());
            authToken = credentialStatusInfo.getAuthToken();
            boolean bl = isStatusValid = credentialStatusInfo.getBody().getStatus() == CredentialStatusOptions.valid;
            if (!isStatusValid) {
                areCredentialsValid = false;
                break;
            }
            Unum<Boolean> isVerifiedResponse = this.verifyCredential(authToken, credential);
            authToken = isVerifiedResponse.getAuthToken();
            if (isVerifiedResponse.getBody().booleanValue()) continue;
            areCredentialsValid = false;
            break;
        }
        if (!areCredentialsValid) {
            VerifiedStatus status = VerifiedStatus.builder().isVerified(false).message("Credential signature can not be verified.").build();
            Unum result = new Unum();
            result.setAuthToken(Utils.handleAuthToken(authToken));
            result.setBody(status);
            return result;
        }
        ArrayList credentialTypesFiltered = new ArrayList();
        for (Credential credential : presentation.getVerifiableCredentialList()) {
            List credentialTypes = credential.getTypeList().stream().filter(type -> !type.equals("VerifiedCredential")).collect(Collectors.toList());
            credentialTypesFiltered.addAll(credentialTypes);
        }
        List issuers = presentation.getVerifiableCredentialList().stream().map(Credential::getIssuer).collect(Collectors.toList());
        Verified verified = Verified.newBuilder().setIsVerified(true).addAllCredentialTypes(credentialTypesFiltered).addAllIssuers(issuers).build();
        PresentationVerifedReceiptOptions receiptOptions = PresentationVerifedReceiptOptions.newBuilder().addType("PresentationVerified").setVerifier(verifierDid).setSubject(presentation.getProof().getVerificationMethod()).setData(verified).build();
        presentationResult.setAuthToken(Utils.handleAuthToken(authToken));
        return presentationResult;
    }

    private void validateVerifiablePresentation(Presentation presentation) {
        if (presentation.getVerifiableCredentialCount() == 0) {
            throw new UnumError(400, "Invalid Presentation: verifiableCredential must be a non-empty array.");
        }
        if (presentation.getContextCount() == 0) {
            throw new UnumError(400, "Invalid Presentation: context must be a non-empty array.");
        }
        if (presentation.getTypeCount() == 0) {
            throw new UnumError(400, "Invalid Presentation: type must be a non-empty array.");
        }
        if (!presentation.getType(0).equals("VerifiablePresentation")) {
            throw new UnumError(400, "Invalid Presentation: type's first array element must be 'VerifiablePresentation'");
        }
        this.validateCredentialInput(presentation.getVerifiableCredentialList());
    }

    private void validateCredentialInput(List<Credential> verifiableCredentialList) {
        for (int i = 0; i < verifiableCredentialList.size(); ++i) {
            String credentialPositionString = "[" + i + "]";
            Credential credential = verifiableCredentialList.get(i);
            String invalidMessage = "Invalid verifiableCredential" + credentialPositionString + ":";
            if (credential.getContextCount() == 0) {
                throw new UnumError(400, invalidMessage + " context must be a non-empty array");
            }
            CredentialSubject credentialSubject = ProtoToDto.convertCredentialSubject(credential.getCredentialSubject());
            if (credentialSubject.getId() == null) {
                throw new UnumError(400, invalidMessage + " credentialSubject must contain id property.");
            }
            if (credential.getTypeCount() != 0) continue;
            throw new UnumError(400, invalidMessage + " type must be a non-empty array.");
        }
    }

    protected Unum<Boolean> verifyCredential(String authToken, Credential credential) throws InvalidProtocolBufferException {
        Proof proof = credential.getProof();
        Unum<DidDocument> didDocument = this._didDocService.getDIDDoc(authToken, proof.getVerificationMethod());
        authToken = didDocument.getAuthToken();
        PublicKeyInfo publicKey = this._didDocService.getKeyFromDIDDoc(didDocument.getBody(), "secp256r1");
        Credential credentialNoProof = credential.toBuilder().clearProof().build();
        String json = JsonFormat.printer().omittingInsignificantWhitespace().print((MessageOrBuilder)credentialNoProof);
        UnsignedCredential.Builder unsignedCredentialBuilder = UnsignedCredential.newBuilder();
        JsonFormat.parser().merge(json, (Message.Builder)unsignedCredentialBuilder);
        UnsignedCredential unsignedCredential = unsignedCredentialBuilder.build();
        byte[] bytes = unsignedCredential.toByteArray();
        boolean isVerified = CryptoUtils.doVerify(proof.getSignatureValue(), bytes, publicKey, publicKey.getEncoding());
        Unum<Boolean> result = new Unum<Boolean>();
        result.setAuthToken(Utils.handleAuthToken(authToken));
        result.setBody(isVerified);
        return result;
    }

    private void validatePresentationMeetsRequestedCredentials(Presentation presentation, List<id.unum.protos.credential.v1.CredentialRequest> credentialRequests) {
        if (presentation.getVerifiableCredentialCount() == 0) {
            return;
        }
        for (id.unum.protos.credential.v1.CredentialRequest requestedCred : credentialRequests) {
            if (!requestedCred.getRequired()) continue;
            List presentationCreds = presentation.getVerifiableCredentialList();
            boolean found = false;
            for (Credential presentationCred : presentationCreds) {
                found = presentationCred.getTypeList().contains((Object)requestedCred.getType());
                if (!found) continue;
                if (requestedCred.getIssuersCount() <= 0 || requestedCred.getIssuersList().contains((Object)presentationCred.getIssuer())) break;
                String errorMessage = "Invalid Presentation: credentials provided did not meet the issuer requirements. Issuer requested: " + requestedCred.getIssuersList() + ". Issuer of the credential received " + presentationCred.getIssuer();
                log.warn(errorMessage);
                throw new UnumError(400, errorMessage);
            }
            if (found) continue;
            String errorMessage = "Invalid Presentation: credentials provided did not meet type requirements. Presented credentials: " + presentation.getVerifiableCredentialList().stream().map(pc -> pc.getTypeList().stream().filter(t -> !t.equals("VerifiableCredential"))).collect(Collectors.toList()) + ". Requested credentials: " + credentialRequests.stream().map(id.unum.protos.credential.v1.CredentialRequest::getType).collect(Collectors.toList()) + ".";
            log.warn(errorMessage);
            throw new UnumError(400, errorMessage);
        }
    }

    private Unum<VerifiedStatus> verifyDeclinedPresentationHelper(String authToken, Presentation presentation, String verifierDid) throws InvalidProtocolBufferException {
        Utils.requireAuth(authToken);
        this.validateDeclinedPresentationInput(presentation);
        String presentationVerifierDid = presentation.getVerifierDid();
        Proof proof = presentation.getProof();
        String verificationMethod = proof.getVerificationMethod();
        Unum<VerifiedStatus> result = this.verifyPresentationProof(authToken, presentation, verifierDid);
        if (result.getBody().isVerified()) {
            PresentationVerifedReceiptOptions receiptOptions = PresentationVerifedReceiptOptions.newBuilder().setVerifier(presentationVerifierDid).addType("DeclinedPresentation").setSubject(verificationMethod).setData(Verified.newBuilder().setIsVerified(true).build()).build();
            try {
                Unum<Receipt> receipt = this._receiptService.createPresentationVerifiedReceipt(authToken, receiptOptions);
                authToken = receipt.getAuthToken();
            }
            catch (Exception e) {
                log.error("Error creating presentation verified receipt: " + e.getMessage());
            }
        }
        return result;
    }

    private Unum<VerifiedStatus> verifyPresentationProof(String authToken, Presentation presentation, String verifierDid) throws InvalidProtocolBufferException {
        String presentationVerifierDid = presentation.getVerifierDid();
        Proof proof = presentation.getProof();
        String verificationMethod = proof.getVerificationMethod();
        String signatureValue = proof.getSignatureValue();
        if (!presentationVerifierDid.equals(verifierDid)) {
            VerifiedStatus status = VerifiedStatus.builder().isVerified(false).message("The presentation was meant for verifier, " + presentationVerifierDid + ", not the provided verifier, " + verifierDid + ".").build();
            Unum<VerifiedStatus> result = new Unum<VerifiedStatus>();
            result.setAuthToken(Utils.handleAuthToken(authToken));
            result.setBody(status);
            return result;
        }
        PublicKeyInfo keyInfo = null;
        try {
            Unum<DidDocument> didDocument = this._didDocService.getDIDDoc(authToken, verificationMethod);
            authToken = didDocument.getAuthToken();
            keyInfo = this._didDocService.getKeyFromDIDDoc(didDocument.getBody(), "secp256r1");
        }
        catch (UnumError error) {
            Unum<VerifiedStatus> result = new Unum<VerifiedStatus>();
            result.setAuthToken(Utils.handleAuthToken(authToken));
            result.setBody(VerifiedStatus.builder().isVerified(false).message("Public key not found for the DID associated with the proof.verificationMethod").build());
        }
        String publicKey = keyInfo.getPublicKey();
        String encoding = keyInfo.getEncoding();
        Presentation presentationNoProof = presentation.toBuilder().clearProof().build();
        String json = JsonFormat.printer().omittingInsignificantWhitespace().print((MessageOrBuilder)presentationNoProof);
        UnsignedPresentation.Builder unsignedPresentationBuilder = UnsignedPresentation.newBuilder();
        JsonFormat.parser().merge(json, (Message.Builder)unsignedPresentationBuilder);
        UnsignedPresentation unsignedPresentation = unsignedPresentationBuilder.build();
        byte[] bytes = unsignedPresentation.toByteArray();
        boolean isVerified = CryptoUtils.doVerify(signatureValue, bytes, keyInfo, encoding);
        if (!isVerified) {
            VerifiedStatus status = VerifiedStatus.builder().isVerified(false).message("Presentation signature can not be verified.").build();
            Unum<VerifiedStatus> result = new Unum<VerifiedStatus>();
            result.setAuthToken(Utils.handleAuthToken(authToken));
            result.setBody(status);
            return result;
        }
        VerifiedStatus status = VerifiedStatus.builder().isVerified(true).build();
        Unum<VerifiedStatus> result = new Unum<VerifiedStatus>();
        result.setAuthToken(Utils.handleAuthToken(authToken));
        result.setBody(status);
        return result;
    }

    private void validateDeclinedPresentationInput(Presentation presentation) {
        if (presentation.getTypeCount() == 0) {
            throw new UnumError(400, "Invalid Presentation: type must be a non-empty array.");
        }
        if (presentation.getVerifiableCredentialCount() != 0) {
            throw new UnumError(400, "Invalid Declined Presentation: verifiableCredential must be null or empty.");
        }
    }

    private Unum<VerifiedStatus> verifyPresentationRequest(String authToken, id.unum.protos.presentationRequest.v1.PresentationRequest presentationRequest) throws InvalidProtocolBufferException {
        if (presentationRequest == null) {
            throw new UnumError(500, "PresentationRequest is null in verify call. This should never happen");
        }
        Proof proof = presentationRequest.getProof();
        String verificationMethod = proof.getVerificationMethod();
        String signatureValue = proof.getSignatureValue();
        Unum<DidDocument> didDocument = this._didDocService.getDIDDoc(authToken, verificationMethod);
        authToken = didDocument.getAuthToken();
        PublicKeyInfo keyInfo = this._didDocService.getKeyFromDIDDoc(didDocument.getBody(), "secp256r1");
        String publicKey = keyInfo.getPublicKey();
        String encoding = keyInfo.getEncoding();
        id.unum.protos.presentationRequest.v1.PresentationRequest presentationRequestNoProof = presentationRequest.toBuilder().clearProof().build();
        String json = JsonFormat.printer().omittingInsignificantWhitespace().print((MessageOrBuilder)presentationRequestNoProof);
        UnsignedPresentationRequest.Builder unsignedPresentationRequestBuilder = UnsignedPresentationRequest.newBuilder();
        JsonFormat.parser().merge(json, (Message.Builder)unsignedPresentationRequestBuilder);
        UnsignedPresentationRequest unsignedPresentationRequest = unsignedPresentationRequestBuilder.build();
        byte[] bytes = unsignedPresentationRequest.toByteArray();
        boolean isVerified = CryptoUtils.doVerify(signatureValue, bytes, keyInfo, encoding);
        if (!isVerified) {
            VerifiedStatus status = VerifiedStatus.builder().isVerified(false).message("PresentationRequest signature can not be verified.").build();
            Unum<VerifiedStatus> result = new Unum<VerifiedStatus>();
            result.setAuthToken(Utils.handleAuthToken(authToken));
            result.setBody(status);
            return result;
        }
        VerifiedStatus status = VerifiedStatus.builder().isVerified(true).build();
        Unum<VerifiedStatus> result = new Unum<VerifiedStatus>();
        result.setAuthToken(Utils.handleAuthToken(authToken));
        result.setBody(status);
        return result;
    }

    protected Unum<PresentationRequestRepoDto> getPresentationRequest(String authToken, String presentationRequestId) {
        Call<PresentationRequestRepoDto> call = this._unumService.getPresentationRequest(authToken, presentationRequestId);
        try {
            Response response = call.execute();
            if (!response.isSuccessful()) {
                String message = response.errorBody() != null ? response.errorBody().string() : "Unknown error";
                log.error("Saas error calling get presentationRequestRepo " + message);
                throw new UnumError(response.errorBody().hashCode(), message);
            }
            PresentationRequestRepoDto dto = (PresentationRequestRepoDto)response.body();
            if (dto == null) {
                throw new UnumError(404, "presentationRequestId " + presentationRequestId + " not found");
            }
            String newAuthToken = response.headers().get("X-Auth-Token");
            Unum<PresentationRequestRepoDto> result = new Unum<PresentationRequestRepoDto>();
            result.setAuthToken(Utils.handleAuthToken(newAuthToken));
            result.setBody(dto);
            return result;
        }
        catch (IOException e) {
            log.error("IOException calling get presentationRequestRepoDto: " + e.toString());
            e.printStackTrace();
            throw new UnumError(500, "Unknown error getting presentationRequests via SaaS repo.");
        }
    }

    private id.unum.protos.presentationRequest.v1.PresentationRequest validatePresentationRequest(PresentationRequest presentationRequest) throws InvalidProtocolBufferException, JsonProcessingException {
        if (presentationRequest.getCredentialRequests() == null) {
            throw new UnumError(400, "Invalid PresentationRequest: credentialRequests is required.");
        }
        if (presentationRequest.getHolderAppUuid() == null) {
            throw new UnumError(400, "Invalid PresentationRequest: holderAppUuid is required.");
        }
        if (presentationRequest.getProof() == null) {
            throw new UnumError(400, "Invalid PresentationRequest: proof is required.");
        }
        if (presentationRequest.getVerifier() == null) {
            throw new UnumError(400, "Invalid PresentationRequest: verifier is required.");
        }
        this.validateCredentialRequests(presentationRequest.getCredentialRequests());
        return DtoToProto.convertPresentationRequestToProto(presentationRequest);
    }

    private void validateCredentialRequests(List<CredentialRequest> credentialRequests) {
        if (credentialRequests.size() == 0) {
            throw new UnumError(400, "Invalid PresentationRequest: credentialRequests must be a non-empty array..");
        }
        for (int i = 0; i < credentialRequests.size(); ++i) {
            String credentialPositionString = "[" + i + "]";
            CredentialRequest request = credentialRequests.get(i);
            if (request.getType() == null) {
                throw new UnumError(400, "Invalid PresentationRequest CredentialRequest " + credentialPositionString + ": type must be defined.");
            }
            if (request.getIssuers() != null) continue;
            throw new UnumError(400, "Invalid PresentationRequest CredentialRequest " + credentialPositionString + ": issuers must be defined.");
        }
    }

    private void validatePresentation(Presentation presentation) {
        if (presentation.getContextCount() == 0) {
            throw new UnumError(400, "Invalid Presentation: context must be a non-empty array.");
        }
        if (presentation.getTypeCount() == 0) {
            throw new UnumError(400, "Invalid Presentation: type must be a non-empty array.");
        }
    }

    private void validateVerifyPresentationInput(EncryptedData encryptedPresentation, String verifierDid, KeyPair keyPair, id.unum.types.dto.PresentationRequestEnriched presentationRequest) {
        if (encryptedPresentation == null) {
            throw new UnumError(400, "encryptedPresentation is required.");
        }
        if (verifierDid == null) {
            throw new UnumError(400, "verifier is required.");
        }
        if (keyPair == null) {
            throw new UnumError(400, "verifier encryptionPrivateKey is required.");
        }
        if (presentationRequest != null && !presentationRequest.getVerifier().getDid().equals(verifierDid)) {
            throw new UnumError(400, "verifier provided " + verifierDid + " does not match request verifier " + presentationRequest.getVerifier().getDid() + ".");
        }
    }

    @Override
    public Unum<Success> sendSms(String authToken, String to, String deeplink) throws UnumError {
        log.info("calling send sms");
        Utils.requireAuth(authToken);
        ExternalMessage request = ExternalMessage.newBuilder().setDeeplink(deeplink).setTo(to).build();
        Call<Success> call = this._unumService.sendSms(authToken, request);
        try {
            Response response = call.execute();
            if (!response.isSuccessful()) {
                String message = response.errorBody() != null ? response.errorBody().string() : "Unknown error";
                log.error("Saas error sending sms" + message);
                throw new UnumError(response.errorBody().hashCode(), message);
            }
            String newAuthToken = response.headers().get("X-Auth-Token");
            Unum<Success> result = new Unum<Success>();
            result.setBody((Success)response.body());
            result.setAuthToken(Utils.handleAuthToken(newAuthToken));
            return result;
        }
        catch (IOException e) {
            log.error("IOException sending sms: " + e.toString());
            e.printStackTrace();
            throw new UnumError(500, "Unknown error sending sms.");
        }
    }

    @Override
    public Unum<Success> sendEmail(String authToken, String to, String deeplink) throws UnumError {
        log.info("calling send email");
        Utils.requireAuth(authToken);
        SendMessageRequest request = new SendMessageRequest();
        request.setTo(to);
        request.setDeeplink(deeplink);
        Call<Success> call = this._unumService.sendEmail(authToken, request);
        try {
            Response response = call.execute();
            if (!response.isSuccessful()) {
                String message = response.errorBody() != null ? response.errorBody().string() : "Unknown error";
                log.error("Saas error sending email" + message);
                throw new UnumError(response.errorBody().hashCode(), message);
            }
            String newAuthToken = response.headers().get("X-Auth-Token");
            Unum<Success> result = new Unum<Success>();
            result.setBody((Success)response.body());
            result.setAuthToken(Utils.handleAuthToken(newAuthToken));
            return result;
        }
        catch (IOException e) {
            log.error("IOException sending email: " + e.toString());
            e.printStackTrace();
            throw new UnumError(500, "Unknown error sending sms.");
        }
    }

    @Override
    public Unum<id.unum.dto.CredentialStatusInfo> checkCredentialStatus(String authToken, String credentialId) throws UnumError {
        log.info("calling check credential status");
        Utils.requireAuth(authToken);
        Call<CredentialStatusInfo> call = this._unumService.checkCredentialStatus(authToken, credentialId);
        try {
            Response response = call.execute();
            if (!response.isSuccessful()) {
                String message = response.errorBody() != null ? response.errorBody().string() : "Unknown error";
                log.error("Saas error calling check credential status " + message);
                throw new UnumError(response.errorBody().hashCode(), message);
            }
            String newAuthToken = response.headers().get("X-Auth-Token");
            Unum<id.unum.dto.CredentialStatusInfo> result = new Unum<id.unum.dto.CredentialStatusInfo>();
            result.setBody(ProtoToDto.convertCredentialStatusInfo((CredentialStatusInfo)response.body()));
            result.setAuthToken(Utils.handleAuthToken(newAuthToken));
            return result;
        }
        catch (IOException e) {
            log.error("IOException calling check credential status: " + e.toString());
            e.printStackTrace();
            throw new UnumError(500, "Unknown error checking credential status.");
        }
    }

    private void validateSendRequestInput(String verifier, List<CredentialRequest> credentialRequests, String signingPrivateKey, String holderAppUuid) throws UnumError {
    }
}

