/*
 * Decompiled with CFR 0.152.
 */
package id.unum.utils;

import id.unum.crossPlatformInterfaces.CryptoLibJvm;
import id.unum.crossPlatformInterfaces.Encoding;
import id.unum.protos.crypto.v1.EncryptedData;
import id.unum.protos.crypto.v1.KeyPair;
import id.unum.protos.crypto.v1.PublicKeyInfo;
import java.nio.charset.StandardCharsets;

public class CryptoLibUtil {
    private static CryptoLibUtil instance;
    private final CryptoLibJvm cryptoLibJvm = new CryptoLibJvm();

    private CryptoLibUtil() {
    }

    public static CryptoLibUtil getInstance() {
        if (instance == null) {
            instance = new CryptoLibUtil();
        }
        return instance;
    }

    public KeyPair generateRsaKey(Encoding encoding) {
        return this.cryptoLibJvm.generateRsaKey(encoding);
    }

    public KeyPair generateEccKey(Encoding encoding) {
        return this.cryptoLibJvm.generateEcKey(encoding);
    }

    public byte[] decryptBytes(KeyPair keyPair, EncryptedData encryptedData) {
        byte[] iv = this.cryptoLibJvm.decryptData(encryptedData.getKey().getIv(), keyPair);
        byte[] algorithm = this.cryptoLibJvm.decryptData(encryptedData.getKey().getAlgorithm(), keyPair);
        byte[] key = this.cryptoLibJvm.decryptData(encryptedData.getKey().getKey(), keyPair);
        if (iv != null && algorithm != null && key != null) {
            return this.cryptoLibJvm.decryptWithOptions(encryptedData.getData(), iv, new String(algorithm, StandardCharsets.UTF_8), key);
        }
        return null;
    }

    public boolean doVerify(String signature, byte[] bytes, PublicKeyInfo publicKey, String encoding) {
        return this.cryptoLibJvm.verifyDataWithProvidedKey(publicKey, bytes, signature);
    }

    public String encrypt(byte[] data, KeyPair keyPair) {
        return this.cryptoLibJvm.encryptData(data, keyPair);
    }

    public EncryptedData encryptWithOptions(byte[] data, byte[] iv, String algorithm, byte[] key, String did, String pemKey) {
        return this.cryptoLibJvm.encryptDataWithOptions(data, iv, algorithm, key, did, pemKey);
    }

    public String sign(byte[] bytes, String privateKey, String encoding) {
        KeyPair keyPair = KeyPair.newBuilder().setPrivateKey(privateKey).build();
        return this.cryptoLibJvm.signData(bytes, keyPair);
    }
}

