/*
 * Decompiled with CFR 0.152.
 */
package id.unum.facade.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import id.unum.facade.rest.serialization.CredentialStatusInfoDeserializer;
import id.unum.facade.rest.serialization.DidDocumentDeserializer;
import id.unum.facade.rest.serialization.ExternalMessageSerializer;
import id.unum.facade.rest.serialization.IssueCredentialRequestSerializer;
import id.unum.facade.rest.serialization.IssuerDeserializer;
import id.unum.facade.rest.serialization.PresentationRequestEnrichedDeserializer;
import id.unum.facade.rest.serialization.PresentationRequestRepoDtoDeserializer;
import id.unum.facade.rest.serialization.PresentationRequestSerializer;
import id.unum.facade.rest.serialization.PresentationVerifiedReceiptOptionsSerializer;
import id.unum.facade.rest.serialization.PublicKeyInfoDeserializer;
import id.unum.facade.rest.serialization.VerifierDeserializer;
import id.unum.protos.credential.v1.CredentialStatusInfo;
import id.unum.protos.credential.v1.IssueCredentialRequest;
import id.unum.protos.crypto.v1.PublicKeyInfo;
import id.unum.protos.didDocument.v1.DidDocument;
import id.unum.protos.externalMessage.v1.ExternalMessage;
import id.unum.protos.issuer.v1.Issuer;
import id.unum.protos.presentationRequest.v1.PresentationRequest;
import id.unum.protos.presentationRequestEnriched.v1.PresentationRequestEnriched;
import id.unum.protos.presentationRequestEnriched.v1.PresentationRequestRepoDto;
import id.unum.protos.receipt.v1.PresentationVerifiedReceiptOptions;
import id.unum.protos.verifier.v1.Verifier;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class Client {
    private Retrofit retrofit;

    public Client(String baseUrl) {
        OkHttpClient.Builder httpClient = new OkHttpClient.Builder();
        httpClient.addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request().newBuilder().addHeader("version", "3.0.0").build();
                return chain.proceed(request);
            }
        });
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
        logging.setLevel(HttpLoggingInterceptor.Level.BODY);
        httpClient.addInterceptor((Interceptor)logging);
        this.retrofit = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)Client.buildGsonConverter()).client(httpClient.build()).build();
    }

    public Retrofit getRetrofit() {
        return this.retrofit;
    }

    private static GsonConverterFactory buildGsonConverter() {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(PresentationRequestEnriched.class, (Object)new PresentationRequestEnrichedDeserializer());
        gsonBuilder.registerTypeAdapter(DidDocument.class, (Object)new DidDocumentDeserializer());
        gsonBuilder.registerTypeAdapter(PublicKeyInfo.class, (Object)new PublicKeyInfoDeserializer());
        gsonBuilder.registerTypeAdapter(Issuer.class, (Object)new IssuerDeserializer());
        gsonBuilder.registerTypeAdapter(Verifier.class, (Object)new VerifierDeserializer());
        gsonBuilder.registerTypeAdapter(CredentialStatusInfo.class, (Object)new CredentialStatusInfoDeserializer());
        gsonBuilder.registerTypeAdapter(PresentationRequestRepoDto.class, (Object)new PresentationRequestRepoDtoDeserializer());
        gsonBuilder.registerTypeAdapter(ExternalMessage.class, (Object)new ExternalMessageSerializer());
        gsonBuilder.registerTypeAdapter(PresentationRequest.class, (Object)new PresentationRequestSerializer());
        gsonBuilder.registerTypeAdapter(IssueCredentialRequest.class, (Object)new IssueCredentialRequestSerializer());
        gsonBuilder.registerTypeAdapter(PresentationVerifiedReceiptOptions.class, (Object)new PresentationVerifiedReceiptOptionsSerializer());
        Gson myGson = gsonBuilder.create();
        return GsonConverterFactory.create((Gson)myGson);
    }
}

