/*
 * Decompiled with CFR 0.152.
 */
package id.unum.facade.rest;

import id.unum.dto.Success;
import id.unum.facade.rest.request.RegisterIssuerRequest;
import id.unum.facade.rest.request.RegisterVerifierRequest;
import id.unum.facade.rest.request.SendMessageRequest;
import id.unum.facade.rest.request.UpdateCredentialStatusRequest;
import id.unum.protos.credential.v1.CredentialStatusInfo;
import id.unum.protos.credential.v1.IssueCredentialRequest;
import id.unum.protos.crypto.v1.PublicKeyInfo;
import id.unum.protos.didDocument.v1.DidDocument;
import id.unum.protos.externalMessage.v1.ExternalMessage;
import id.unum.protos.issuer.v1.Issuer;
import id.unum.protos.presentationRequest.v1.PresentationRequest;
import id.unum.protos.presentationRequestEnriched.v1.PresentationRequestEnriched;
import id.unum.protos.presentationRequestEnriched.v1.PresentationRequestRepoDto;
import id.unum.protos.receipt.v1.PresentationVerifiedReceiptOptions;
import id.unum.protos.receipt.v1.Receipt;
import id.unum.protos.verifier.v1.Verifier;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.Path;

public interface UnumAPIService {
    @POST(value="/issuer")
    public Call<Issuer> registerIssuer(@Header(value="Authorization") String var1, @Body RegisterIssuerRequest var2);

    @POST(value="/credentialRepository")
    public Call<Success> issueCredential(@Header(value="Authorization") String var1, @Body IssueCredentialRequest var2);

    @PATCH(value="/credentialStatus/{uuid}")
    public Call<Success> updateCredentialStatus(@Header(value="Authorization") String var1, @Path(value="uuid") String var2, @Body UpdateCredentialStatusRequest var3);

    @POST(value="/verifier")
    public Call<Verifier> registerVerifier(@Header(value="Authorization") String var1, @Body RegisterVerifierRequest var2);

    @POST(value="/presentationRequest")
    public Call<PresentationRequestEnriched> sendRequest(@Header(value="Authorization") String var1, @Body PresentationRequest var2);

    @GET(value="/credentialStatus/{id}")
    public Call<CredentialStatusInfo> checkCredentialStatus(@Header(value="Authorization") String var1, @Path(value="id") String var2);

    @POST(value="/sms")
    public Call<Success> sendSms(@Header(value="Authorization") String var1, @Body ExternalMessage var2);

    @POST(value="/email")
    public Call<Success> sendEmail(@Header(value="Authorization") String var1, @Body SendMessageRequest var2);

    @GET(value="/presentationRequestRepository/{id}")
    public Call<PresentationRequestRepoDto> getPresentationRequest(@Header(value="Authorization") String var1, @Path(value="id") String var2);

    @GET(value="/didDocument/{did}")
    public Call<DidDocument> getDidDoc(@Header(value="Authorization") String var1, @Path(value="did") String var2);

    @GET(value="/didDocument/{didWithKeyId}")
    public Call<PublicKeyInfo> getDidDocKey(@Header(value="Authorization") String var1, @Path(value="didWithKeyId") String var2);

    @POST(value="/receipt")
    public Call<Receipt> createPresentationVerifiedReceipt(@Header(value="Authorization") String var1, @Body PresentationVerifiedReceiptOptions var2);
}

