/*
 * Decompiled with CFR 0.152.
 */
package id.unum.facade.rest.serialization;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import id.unum.protos.issuer.v1.Issuer;
import java.lang.reflect.Type;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IssuerDeserializer
implements JsonDeserializer<Issuer> {
    private static final Logger log = LogManager.getLogger(IssuerDeserializer.class);

    public Issuer deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        Issuer.Builder builder = Issuer.newBuilder();
        try {
            JsonFormat.parser().ignoringUnknownFields().merge(jsonElement.toString(), (Message.Builder)builder);
        }
        catch (InvalidProtocolBufferException e) {
            log.error("Issue deserializing RegisterIssuerResponse: " + e.getMessage());
            e.printStackTrace();
        }
        return builder.build();
    }
}

