/*
 * Decompiled with CFR 0.152.
 */
package id.unum.service;

import id.unum.dto.Unum;
import id.unum.error.UnumError;
import id.unum.facade.rest.Client;
import id.unum.facade.rest.UnumAPIService;
import id.unum.protos.crypto.v1.PublicKeyInfo;
import id.unum.protos.didDocument.v1.DidDocument;
import id.unum.service.DidDocServiceInterface;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import retrofit2.Call;
import retrofit2.Response;

public class DidDocService
implements DidDocServiceInterface {
    private static final Logger log = LogManager.getLogger(DidDocService.class);
    private UnumAPIService _unumService;

    public DidDocService(String url) {
        Client client = new Client(url);
        this._unumService = (UnumAPIService)client.getRetrofit().create(UnumAPIService.class);
    }

    @Override
    public Unum<PublicKeyInfo> getDidDocPublicKeyInfoByKeyId(String authToken, String didWithKeyId) {
        if (didWithKeyId == null || didWithKeyId.isEmpty()) {
            throw new UnumError(500, "Did doc get needs a did.");
        }
        if (didWithKeyId.length() != 82 || !didWithKeyId.contains("#")) {
            throw new UnumError(500, "Did doc get needs a did with key id.");
        }
        Call<PublicKeyInfo> call = this._unumService.getDidDocKey(authToken, didWithKeyId);
        try {
            Response response = call.execute();
            if (!response.isSuccessful()) {
                String message = response.errorBody() != null ? response.errorBody().string() : "Unknown error";
                log.error("Saas error calling get did doc " + didWithKeyId + ": " + message);
                throw new UnumError(response.errorBody().hashCode(), message);
            }
            PublicKeyInfo keyInfo = (PublicKeyInfo)response.body();
            if (keyInfo == null) {
                throw new UnumError(404, "Did doc with key id " + didWithKeyId + " not found");
            }
            String newAuthToken = response.headers().get("X-Auth-Token");
            Unum<PublicKeyInfo> result = new Unum<PublicKeyInfo>();
            result.setAuthToken(newAuthToken);
            result.setBody(keyInfo);
            return result;
        }
        catch (IOException e) {
            log.error("IOException calling get did doc with key id: " + e.toString());
            e.printStackTrace();
            throw new UnumError(500, "Unknown error getting did doc with key id.");
        }
    }

    @Override
    public Unum<DidDocument> getDIDDoc(String authToken, String did) throws UnumError {
        if (did == null || did.isEmpty()) {
            throw new UnumError(500, "Did doc get needs a did.");
        }
        Call<DidDocument> call = this._unumService.getDidDoc(authToken, did);
        try {
            Response response = call.execute();
            if (!response.isSuccessful()) {
                String message = response.errorBody() != null ? response.errorBody().string() : "Unknown error";
                log.error("Saas error calling get did doc " + did + ": " + message);
                throw new UnumError(response.errorBody().hashCode(), message);
            }
            DidDocument didDocument = (DidDocument)response.body();
            if (didDocument == null) {
                throw new UnumError(404, "Did document " + did + " not found");
            }
            String newAuthToken = response.headers().get("X-Auth-Token");
            Unum<DidDocument> result = new Unum<DidDocument>();
            result.setAuthToken(newAuthToken);
            result.setBody(didDocument);
            return result;
        }
        catch (IOException e) {
            log.error("IOException calling get did doc: " + e.toString());
            e.printStackTrace();
            throw new UnumError(500, "Unknown error getting did doc.");
        }
    }

    @Override
    public List<PublicKeyInfo> getKeysFromDIDDoc(DidDocument document, String type) {
        List<PublicKeyInfo> pubKeys = document.getPublicKeyList().stream().filter(publicKeyInfo -> publicKeyInfo.getType().equals(type)).collect(Collectors.toList());
        if (pubKeys.isEmpty()) {
            throw new UnumError(404, "Public key not found for the DID");
        }
        return pubKeys;
    }

    @Override
    public PublicKeyInfo getKeyFromDIDDoc(DidDocument document, String type) {
        List<PublicKeyInfo> pubKeys = this.getKeysFromDIDDoc(document, type);
        return pubKeys.get(0);
    }
}

