/*
 * Decompiled with CFR 0.152.
 */
package id.unum.service;

import id.unum.dto.Unum;
import id.unum.error.UnumError;
import id.unum.facade.rest.Client;
import id.unum.facade.rest.UnumAPIService;
import id.unum.protos.receipt.v1.PresentationVerifiedReceiptOptions;
import id.unum.protos.receipt.v1.Receipt;
import id.unum.protos.receipt.v1.Verified;
import id.unum.service.ReceiptServiceInterface;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import retrofit2.Call;
import retrofit2.Response;

public class ReceiptService
implements ReceiptServiceInterface {
    private static final Logger log = LogManager.getLogger(ReceiptService.class);
    private UnumAPIService _unumService;

    public ReceiptService(String url) {
        Client client = new Client(url);
        this._unumService = (UnumAPIService)client.getRetrofit().create(UnumAPIService.class);
    }

    @Override
    public Unum<Receipt> sendPresentationVerifiedReceipt(String authToken, String verifierDid, String subjectDid, String reply, boolean isVerified, String requestId, String requestUuid, String reason, List<String> issuers, List<String> credentialTypes) {
        Verified verified = Verified.newBuilder().setIsVerified(isVerified).addAllCredentialTypes(credentialTypes).addAllIssuers(issuers).setReason(reason).setReply(reply).setRequestId(requestId).setRequestUuid(requestUuid).build();
        PresentationVerifiedReceiptOptions receiptOptions = PresentationVerifiedReceiptOptions.newBuilder().setType("PresentationVerified").setVerifier(verifierDid).setSubject(subjectDid).setData(verified).build();
        Unum<Receipt> receipt = this.createPresentationVerifiedReceipt(authToken, receiptOptions);
        return receipt;
    }

    @Override
    public Unum<Receipt> createPresentationVerifiedReceipt(String authToken, PresentationVerifiedReceiptOptions options) {
        Call<Receipt> call = this._unumService.createPresentationVerifiedReceipt(authToken, options);
        try {
            Response response = call.execute();
            if (!response.isSuccessful()) {
                String message = response.errorBody() != null ? response.errorBody().string() : "Unknown error";
                log.error("Saas error calling register issuer " + message);
                throw new UnumError(response.errorBody().hashCode(), message);
            }
            String newAuthToken = response.headers().get("X-Auth-Token");
            Unum<Receipt> result = new Unum<Receipt>();
            result.setBody((Receipt)response.body());
            result.setAuthToken(newAuthToken);
            return result;
        }
        catch (IOException e) {
            log.error("IOException calling saas create receipt: " + e.getMessage());
            e.printStackTrace();
            throw new UnumError(500, "Error creating receipt.");
        }
    }
}

