/*
 * Decompiled with CFR 0.152.
 */
package id.unum.utils;

import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import id.unum.crossPlatformInterfaces.Encoding;
import id.unum.error.UnumError;
import id.unum.protos.credential.v1.Credential;
import id.unum.protos.crypto.v1.KeyPair;
import id.unum.protos.crypto.v1.KeyPairSet;
import id.unum.protos.presentation.v1.Presentation;
import id.unum.types.PublicKeyInfo;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class Utils {
    public static void requireAuth(String auth) throws UnumError {
        if (auth == null) {
            throw new UnumError(403, "Auth is required");
        }
    }

    public static List<String> getVersionList() {
        return Arrays.asList("3.0.0");
    }

    public static List<PublicKeyInfo> extractPublicKeyInfo(KeyPairSet keyPairSet, Encoding encoding) {
        PublicKeyInfo signingPublicKeyInfo = Utils.constructKeyInfo(keyPairSet.getSigning(), "secp256r1", encoding);
        PublicKeyInfo encryptionPublicKeyInfo = Utils.constructKeyInfo(keyPairSet.getEncryption(), "RSA", encoding);
        return Arrays.asList(signingPublicKeyInfo, encryptionPublicKeyInfo);
    }

    public static boolean isDeclinedPresentation(Presentation presentation) {
        return presentation.getVerifiableCredentialCount() == 0;
    }

    public static boolean isCredentialExpired(Credential credential) {
        Timestamp now;
        Timestamp expirationDate = credential.getExpirationDate();
        return Timestamps.compare((Timestamp)expirationDate, (Timestamp)(now = Timestamps.fromMillis((long)System.currentTimeMillis()))) < 0;
    }

    public static String getCredentialType(Credential credential) {
        if (credential.getTypeCount() < 2) {
            throw new UnumError(500, "Credential type is not W3C compliant " + credential.getTypeList());
        }
        return credential.getType(1);
    }

    public static String handleAuthToken(String input) {
        return input != null ? (input.startsWith("Bearer ") ? input : "Bearer " + input) : input;
    }

    private static PublicKeyInfo constructKeyInfo(KeyPair keyPair, String type, Encoding encoding) {
        Date now = new Date();
        UUID uuid = UUID.randomUUID();
        PublicKeyInfo result = new PublicKeyInfo();
        result.setId(uuid.toString());
        result.setPublicKey(keyPair.getPublicKey());
        result.setEncoding(encoding.toString().toLowerCase());
        result.setType(type);
        result.setStatus("valid");
        result.setCreatedAt(now.toString());
        result.setUpdatedAt(now.toString());
        return result;
    }
}

