/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.java.aggregation;

import info.debatty.java.aggregation.InterpolationFunction;
import info.debatty.java.aggregation.Line;
import info.debatty.java.aggregation.Point;

class InterpolationFunctions {
    private static final double INFINITY = Double.MAX_VALUE;
    private final Point[] points;
    private final InterpolationFunction[] functions;

    InterpolationFunctions(Point[] points) {
        int i;
        int size = points.length;
        this.points = points;
        double[] point_coefs = new double[points.length - 1];
        for (int i2 = 0; i2 < size - 1; ++i2) {
            point_coefs[i2] = Point.computeCoef(points[i2], points[i2 + 1]);
        }
        double[] line_coefs = new double[points.length];
        for (int i3 = 1; i3 < size - 1; ++i3) {
            line_coefs[i3] = Point.computeLineCoef(point_coefs[i3 - 1], point_coefs[i3], points[i3], points[i3 - 1], points[i3 + 1]);
        }
        line_coefs[0] = line_coefs[1] == 0.0 && point_coefs[0] == 0.0 ? 0.0 : (line_coefs[1] == 0.0 ? Double.MAX_VALUE : point_coefs[0] * point_coefs[0] / line_coefs[1]);
        line_coefs[size - 1] = line_coefs[size - 2] == 0.0 && point_coefs[size - 2] == 0.0 ? 0.0 : (line_coefs[size - 2] == 0.0 ? Double.MAX_VALUE : point_coefs[size - 2] * point_coefs[size - 2] / line_coefs[size - 2]);
        Line[] lines = new Line[points.length];
        for (i = 0; i < size; ++i) {
            lines[i] = new Line(line_coefs[i], points[i].y - line_coefs[i] * points[i].x);
        }
        this.functions = new InterpolationFunction[size - 1];
        for (i = 0; i < size - 1; ++i) {
            this.functions[i] = new InterpolationFunction(lines[i], lines[i + 1], points[i], points[i + 1]);
        }
    }

    public double eval(double value) {
        if (value <= this.points[0].x) {
            return 0.0;
        }
        for (int i = 0; i < this.points.length - 1; ++i) {
            if (!(value <= this.points[i + 1].x)) continue;
            return this.functions[i].eval(value);
        }
        return 1.0;
    }
}

