/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import io.appium.java_client.ErrorCodesMobile;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.openqa.selenium.WebDriverException;

public class MobileErrorHandler {
    private final ErrorCodesMobile errorCodes = new ErrorCodesMobile();

    public void throwIfMobileError(WebDriverException originalException) throws RuntimeException {
        Class<? extends WebDriverException> mobileErrorType = this.errorCodes.getExceptionType(originalException.getMessage());
        if (mobileErrorType == null) {
            throw originalException;
        }
        WebDriverException toThrow = null;
        if (toThrow == null) {
            toThrow = this.createThrowable(mobileErrorType, new Class[]{String.class, Throwable.class}, new Object[]{originalException.getMessage(), originalException.getCause()});
        }
        if (toThrow == null) {
            toThrow = this.createThrowable(mobileErrorType, new Class[]{String.class}, new Object[]{originalException.getMessage()});
        }
        if (toThrow == null) {
            toThrow = originalException;
        }
        throw toThrow;
    }

    private <T extends Throwable> T createThrowable(Class<T> clazz, Class<?>[] parameterTypes, Object[] parameters) {
        try {
            Constructor<T> constructor = clazz.getConstructor(parameterTypes);
            return (T)((Throwable)constructor.newInstance(parameters));
        }
        catch (NoSuchMethodException e) {
        }
        catch (InvocationTargetException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (OutOfMemoryError error) {
            // empty catch block
        }
        return null;
    }
}

