/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.pagefactory;

import io.appium.java_client.MobileBy;
import io.appium.java_client.pagefactory.AndroidFindAll;
import io.appium.java_client.pagefactory.AndroidFindBy;
import io.appium.java_client.pagefactory.AndroidFindBys;
import io.appium.java_client.pagefactory.SelendroidFindAll;
import io.appium.java_client.pagefactory.SelendroidFindBy;
import io.appium.java_client.pagefactory.SelendroidFindBys;
import io.appium.java_client.pagefactory.iOSFindAll;
import io.appium.java_client.pagefactory.iOSFindBy;
import io.appium.java_client.pagefactory.iOSFindBys;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.support.pagefactory.Annotations;
import org.openqa.selenium.support.pagefactory.ByAll;
import org.openqa.selenium.support.pagefactory.ByChained;

class AppiumAnnotations
extends Annotations {
    private static final List<String> METHODS_TO_BE_EXCLUDED_WHEN_ANNOTATION_IS_READ = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            List objectClassMethodNames = AppiumAnnotations.getMethodNames(Object.class.getDeclaredMethods());
            this.addAll(objectClassMethodNames);
            List annotationClassMethodNames = AppiumAnnotations.getMethodNames(Annotation.class.getDeclaredMethods());
            annotationClassMethodNames.removeAll(objectClassMethodNames);
            this.addAll(annotationClassMethodNames);
        }
    };
    private static final Class<?>[] DEFAULT_ANNOTATION_METHOD_ARGUMENTS = new Class[0];
    private final Field mobileField;
    private final String platform;
    private final String automation;
    private final boolean isBrowser;

    private static List<String> getMethodNames(Method[] methods) {
        ArrayList<String> names = new ArrayList<String>();
        for (Method m : methods) {
            names.add(m.getName());
        }
        return names;
    }

    AppiumAnnotations(Field field, String platform, String automation, boolean isBrowser) {
        super(field);
        this.mobileField = field;
        this.platform = String.valueOf(platform).toUpperCase().trim();
        this.automation = String.valueOf(automation).toUpperCase().trim();
        this.isBrowser = isBrowser;
    }

    private static void checkDisallowedAnnotationPairs(Annotation a1, Annotation a2) throws IllegalArgumentException {
        if (a1 != null && a2 != null) {
            throw new IllegalArgumentException("If you use a '@" + a1.getClass().getSimpleName() + "' annotation, " + "you must not also use a '@" + a2.getClass().getSimpleName() + "' annotation");
        }
    }

    private void assertValidAnnotations() {
        AndroidFindBy androidBy = this.mobileField.getAnnotation(AndroidFindBy.class);
        AndroidFindBys androidBys = this.mobileField.getAnnotation(AndroidFindBys.class);
        AndroidFindAll androidFindAll = this.mobileField.getAnnotation(AndroidFindAll.class);
        SelendroidFindBy selendroidBy = this.mobileField.getAnnotation(SelendroidFindBy.class);
        SelendroidFindBys selendroidBys = this.mobileField.getAnnotation(SelendroidFindBys.class);
        SelendroidFindAll selendroidFindAll = this.mobileField.getAnnotation(SelendroidFindAll.class);
        iOSFindBy iOSBy = this.mobileField.getAnnotation(iOSFindBy.class);
        iOSFindBys iOSBys = this.mobileField.getAnnotation(iOSFindBys.class);
        iOSFindAll iOSFindAll2 = this.mobileField.getAnnotation(iOSFindAll.class);
        AppiumAnnotations.checkDisallowedAnnotationPairs(androidBy, androidBys);
        AppiumAnnotations.checkDisallowedAnnotationPairs(androidBy, androidFindAll);
        AppiumAnnotations.checkDisallowedAnnotationPairs(androidBys, androidFindAll);
        AppiumAnnotations.checkDisallowedAnnotationPairs(selendroidBy, selendroidBys);
        AppiumAnnotations.checkDisallowedAnnotationPairs(selendroidBy, selendroidFindAll);
        AppiumAnnotations.checkDisallowedAnnotationPairs(selendroidBys, selendroidFindAll);
        AppiumAnnotations.checkDisallowedAnnotationPairs(iOSBy, iOSBys);
        AppiumAnnotations.checkDisallowedAnnotationPairs(iOSBy, iOSFindAll2);
        AppiumAnnotations.checkDisallowedAnnotationPairs(iOSBys, iOSFindAll2);
    }

    private static Method[] prepareAnnotationMethods(Class<? extends Annotation> annotation) {
        List<String> targeAnnotationMethodNamesList = AppiumAnnotations.getMethodNames(annotation.getDeclaredMethods());
        targeAnnotationMethodNamesList.removeAll(METHODS_TO_BE_EXCLUDED_WHEN_ANNOTATION_IS_READ);
        Method[] result = new Method[targeAnnotationMethodNamesList.size()];
        for (String methodName : targeAnnotationMethodNamesList) {
            try {
                result[targeAnnotationMethodNamesList.indexOf((Object)methodName)] = annotation.getMethod(methodName, DEFAULT_ANNOTATION_METHOD_ARGUMENTS);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private static String getFilledValue(Annotation mobileBy) {
        Method[] values;
        for (Method value : values = AppiumAnnotations.prepareAnnotationMethods(mobileBy.getClass())) {
            try {
                String strategyParameter = value.invoke((Object)mobileBy, new Object[0]).toString();
                if ("".equals(strategyParameter)) continue;
                return value.getName();
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalArgumentException("@" + mobileBy.getClass().getSimpleName() + ": one of " + Strategies.strategiesNames().toString() + " should be filled");
    }

    private By getMobileBy(Annotation annotation, String valueName) {
        Strategies[] strategies;
        for (Strategies strategy : strategies = Strategies.values()) {
            if (!strategy.returnValueName().equals(valueName)) continue;
            return strategy.getBy(annotation);
        }
        throw new IllegalArgumentException("@" + annotation.getClass().getSimpleName() + ": There is an unknown strategy " + valueName);
    }

    private <T extends By> T getComplexMobileBy(Annotation[] annotations, Class<T> requiredByClass) {
        By[] byArray = new By[annotations.length];
        for (int i = 0; i < annotations.length; ++i) {
            byArray[i] = this.getMobileBy(annotations[i], AppiumAnnotations.getFilledValue(annotations[i]));
        }
        try {
            Constructor<T> c = requiredByClass.getConstructor(By[].class);
            Object[] values = new Object[]{byArray};
            return (T)((By)c.newInstance(values));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public By buildBy() {
        if (this.isBrowser) {
            return super.buildBy();
        }
        this.assertValidAnnotations();
        SelendroidFindBy selendroidBy = this.mobileField.getAnnotation(SelendroidFindBy.class);
        if (selendroidBy != null && "Android".toUpperCase().equals(this.platform) && "Selendroid".toUpperCase().equals(this.automation)) {
            return this.getMobileBy(selendroidBy, AppiumAnnotations.getFilledValue(selendroidBy));
        }
        SelendroidFindBys selendroidBys = this.mobileField.getAnnotation(SelendroidFindBys.class);
        if (selendroidBys != null && "Android".toUpperCase().equals(this.platform) && "Selendroid".toUpperCase().equals(this.automation)) {
            return this.getComplexMobileBy(selendroidBys.value(), ByChained.class);
        }
        SelendroidFindAll selendroidAll = this.mobileField.getAnnotation(SelendroidFindAll.class);
        if (selendroidAll != null && "Android".toUpperCase().equals(this.platform) && "Selendroid".toUpperCase().equals(this.automation)) {
            return this.getComplexMobileBy(selendroidAll.value(), ByAll.class);
        }
        AndroidFindBy androidBy = this.mobileField.getAnnotation(AndroidFindBy.class);
        if (androidBy != null && "Android".toUpperCase().equals(this.platform)) {
            return this.getMobileBy(androidBy, AppiumAnnotations.getFilledValue(androidBy));
        }
        AndroidFindBys androidBys = this.mobileField.getAnnotation(AndroidFindBys.class);
        if (androidBys != null && "Android".toUpperCase().equals(this.platform)) {
            return this.getComplexMobileBy(androidBys.value(), ByChained.class);
        }
        AndroidFindAll androidFindAll = this.mobileField.getAnnotation(AndroidFindAll.class);
        if (androidFindAll != null && "Android".toUpperCase().equals(this.platform)) {
            return this.getComplexMobileBy(androidFindAll.value(), ByAll.class);
        }
        iOSFindBy iOSBy = this.mobileField.getAnnotation(iOSFindBy.class);
        if (iOSBy != null && "iOS".toUpperCase().equals(this.platform)) {
            return this.getMobileBy(iOSBy, AppiumAnnotations.getFilledValue(iOSBy));
        }
        iOSFindBys iOSBys = this.mobileField.getAnnotation(iOSFindBys.class);
        if (iOSBys != null && "iOS".toUpperCase().equals(this.platform)) {
            return this.getComplexMobileBy(iOSBys.value(), ByChained.class);
        }
        iOSFindAll iOSFindAll2 = this.mobileField.getAnnotation(iOSFindAll.class);
        if (iOSFindAll2 != null && "iOS".toUpperCase().equals(this.platform)) {
            return this.getComplexMobileBy(iOSFindAll2.value(), ByAll.class);
        }
        return super.buildBy();
    }

    private static enum Strategies {
        BYUIAUTOMATOR("uiAutomator"){

            @Override
            By getBy(Annotation annotation) {
                String value = Strategies.getValue(annotation, (Strategies)this);
                if (annotation.annotationType().equals(AndroidFindBy.class)) {
                    return MobileBy.AndroidUIAutomator(value);
                }
                if (annotation.annotationType().equals(iOSFindBy.class)) {
                    return MobileBy.IosUIAutomation(value);
                }
                return super.getBy(annotation);
            }
        }
        ,
        BYACCESSABILITY("accessibility"){

            @Override
            By getBy(Annotation annotation) {
                return MobileBy.AccessibilityId(Strategies.getValue(annotation, (Strategies)this));
            }
        }
        ,
        BYCLASSNAME("className"){

            @Override
            By getBy(Annotation annotation) {
                return By.className((String)Strategies.getValue(annotation, (Strategies)this));
            }
        }
        ,
        BYID("id"){

            @Override
            By getBy(Annotation annotation) {
                return By.id((String)Strategies.getValue(annotation, (Strategies)this));
            }
        }
        ,
        BYTAG("tagName"){

            @Override
            By getBy(Annotation annotation) {
                return By.tagName((String)Strategies.getValue(annotation, (Strategies)this));
            }
        }
        ,
        BYNAME("name"){

            @Override
            By getBy(Annotation annotation) {
                return By.name((String)Strategies.getValue(annotation, (Strategies)this));
            }
        }
        ,
        BYXPATH("xpath"){

            @Override
            By getBy(Annotation annotation) {
                return By.xpath((String)Strategies.getValue(annotation, (Strategies)this));
            }
        }
        ,
        BYLINKTEXT("linkText"){

            @Override
            By getBy(Annotation annotation) {
                return By.linkText((String)Strategies.getValue(annotation, (Strategies)this));
            }
        }
        ,
        BYPARTIALLINKTEXT("partialLinkText"){

            @Override
            By getBy(Annotation annotation) {
                return By.partialLinkText((String)Strategies.getValue(annotation, (Strategies)this));
            }
        };

        private final String valueName;

        private String returnValueName() {
            return this.valueName;
        }

        private Strategies(String valueName) {
            this.valueName = valueName;
        }

        private static String[] strategiesNames() {
            Strategies[] strategies = Strategies.values();
            String[] result = new String[strategies.length];
            int i = 0;
            for (Strategies strategy : Strategies.values()) {
                result[i] = strategy.valueName;
                ++i;
            }
            return result;
        }

        private static String getValue(Annotation annotation, Strategies strategy) {
            try {
                Method m = annotation.getClass().getMethod(strategy.valueName, DEFAULT_ANNOTATION_METHOD_ARGUMENTS);
                return m.invoke((Object)annotation, new Object[0]).toString();
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        By getBy(Annotation annotation) {
            return null;
        }
    }
}

