/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.ios;

import com.google.common.collect.ImmutableMap;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.FindsByAccessibilityId;
import io.appium.java_client.FindsByIosUIAutomation;
import io.appium.java_client.ScrollsTo;
import io.appium.java_client.ios.GetsNamedTextField;
import io.appium.java_client.ios.IOSDeviceActionShortcuts;
import io.appium.java_client.ios.internal.JsonToIOSElementConverter;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebElement;

public class IOSDriver<RequiredElementType extends WebElement>
extends AppiumDriver<RequiredElementType>
implements IOSDeviceActionShortcuts,
GetsNamedTextField<RequiredElementType>,
FindsByIosUIAutomation<RequiredElementType> {
    private static final String IOS_PLATFORM = "iOS";

    public IOSDriver(URL remoteAddress, Capabilities desiredCapabilities) {
        super(remoteAddress, IOSDriver.substituteMobilePlatform(desiredCapabilities, IOS_PLATFORM));
        this.setElementConverter(new JsonToIOSElementConverter(this));
    }

    @Override
    public RequiredElementType scrollTo(String text) {
        return (RequiredElementType)((WebElement)((ScrollsTo)this.findElementByClassName("UIATableView")).scrollTo(text));
    }

    @Override
    public RequiredElementType scrollToExact(String text) {
        return (RequiredElementType)((WebElement)((ScrollsTo)this.findElementByClassName("UIATableView")).scrollToExact(text));
    }

    @Override
    public void hideKeyboard(String strategy, String keyName) {
        String[] parameters = new String[]{"strategy", "key"};
        Object[] values = new Object[]{strategy, keyName};
        this.execute("hideKeyboard", (Map)IOSDriver.getCommandImmutableMap(parameters, values));
    }

    @Override
    public void hideKeyboard(String keyName) {
        this.execute("hideKeyboard", (Map)ImmutableMap.of((Object)"keyName", (Object)keyName));
    }

    @Override
    public void shake() {
        this.execute("shake");
    }

    @Override
    public RequiredElementType getNamedTextField(String name) {
        WebElement element = this.findElementByAccessibilityId(name);
        if (element.getTagName() != "TextField") {
            return (RequiredElementType)((WebElement)((FindsByAccessibilityId)element).findElementByAccessibilityId(name));
        }
        return (RequiredElementType)element;
    }

    @Override
    public RequiredElementType findElementByIosUIAutomation(String using) {
        return (RequiredElementType)this.findElement("-ios uiautomation", using);
    }

    @Override
    public List<RequiredElementType> findElementsByIosUIAutomation(String using) {
        return this.findElements("-ios uiautomation", using);
    }
}

