/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import com.google.common.collect.ImmutableMap;
import io.appium.java_client.CanRememberExtensionPresence;
import io.appium.java_client.CommandExecutionHelper;
import io.appium.java_client.ExecutesMethod;
import io.appium.java_client.MobileCommand;
import io.appium.java_client.appmanagement.ApplicationState;
import io.appium.java_client.appmanagement.BaseActivateApplicationOptions;
import io.appium.java_client.appmanagement.BaseInstallApplicationOptions;
import io.appium.java_client.appmanagement.BaseOptions;
import io.appium.java_client.appmanagement.BaseRemoveApplicationOptions;
import io.appium.java_client.appmanagement.BaseTerminateApplicationOptions;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.UnsupportedCommandException;

public interface InteractsWithApps
extends ExecutesMethod,
CanRememberExtensionPresence {
    default public void installApp(String appPath) {
        this.installApp(appPath, null);
    }

    default public void installApp(String appPath, @Nullable BaseInstallApplicationOptions options) {
        String extName = "mobile: installApp";
        try {
            ImmutableMap args = ImmutableMap.builder().put((Object)"app", (Object)appPath).put((Object)"appPath", (Object)appPath).putAll(Optional.ofNullable(options).map(BaseOptions::build).orElseGet(Collections::emptyMap)).build();
            CommandExecutionHelper.executeScript(this.assertExtensionExists("mobile: installApp"), "mobile: installApp", (Map<String, Object>)args);
        }
        catch (InvalidArgumentException | UnsupportedCommandException e) {
            ImmutableMap args = ImmutableMap.builder().put((Object)"appPath", (Object)appPath).putAll(Optional.ofNullable(options).map(opts -> Map.of("options", opts.build())).orElseGet(Map::of)).build();
            CommandExecutionHelper.execute(this.markExtensionAbsence("mobile: installApp"), Map.entry(MobileCommand.INSTALL_APP, args));
        }
    }

    default public boolean isAppInstalled(String bundleId) {
        String extName = "mobile: isAppInstalled";
        try {
            return Objects.requireNonNull((Boolean)CommandExecutionHelper.executeScript(this.assertExtensionExists("mobile: isAppInstalled"), "mobile: isAppInstalled", Map.of("bundleId", bundleId, "appId", bundleId)));
        }
        catch (InvalidArgumentException | UnsupportedCommandException e) {
            return Objects.requireNonNull((Boolean)CommandExecutionHelper.execute(this.markExtensionAbsence("mobile: isAppInstalled"), Map.entry(MobileCommand.IS_APP_INSTALLED, Map.of("bundleId", bundleId))));
        }
    }

    default public void runAppInBackground(Duration duration) {
        String extName = "mobile: backgroundApp";
        try {
            CommandExecutionHelper.executeScript(this.assertExtensionExists("mobile: backgroundApp"), "mobile: backgroundApp", Map.of("seconds", (double)duration.toMillis() / 1000.0));
        }
        catch (UnsupportedCommandException e) {
            CommandExecutionHelper.execute(this.markExtensionAbsence("mobile: backgroundApp"), Map.entry(MobileCommand.RUN_APP_IN_BACKGROUND, Map.of("seconds", (double)duration.toMillis() / 1000.0)));
        }
    }

    default public boolean removeApp(String bundleId) {
        return this.removeApp(bundleId, null);
    }

    default public boolean removeApp(String bundleId, @Nullable BaseRemoveApplicationOptions options) {
        String extName = "mobile: removeApp";
        try {
            ImmutableMap args = ImmutableMap.builder().put((Object)"bundleId", (Object)bundleId).put((Object)"appId", (Object)bundleId).putAll(Optional.ofNullable(options).map(BaseOptions::build).orElseGet(Collections::emptyMap)).build();
            return Objects.requireNonNull((Boolean)CommandExecutionHelper.executeScript(this.assertExtensionExists("mobile: removeApp"), "mobile: removeApp", (Map<String, Object>)args));
        }
        catch (InvalidArgumentException | UnsupportedCommandException e) {
            ImmutableMap args = ImmutableMap.builder().put((Object)"bundleId", (Object)bundleId).putAll(Optional.ofNullable(options).map(opts -> Map.of("options", opts.build())).orElseGet(Map::of)).build();
            return Objects.requireNonNull((Boolean)CommandExecutionHelper.execute(this.markExtensionAbsence("mobile: removeApp"), Map.entry(MobileCommand.REMOVE_APP, args)));
        }
    }

    default public void activateApp(String bundleId) {
        this.activateApp(bundleId, null);
    }

    default public void activateApp(String bundleId, @Nullable BaseActivateApplicationOptions options) {
        String extName = "mobile: activateApp";
        try {
            ImmutableMap args = ImmutableMap.builder().put((Object)"bundleId", (Object)bundleId).put((Object)"appId", (Object)bundleId).putAll(Optional.ofNullable(options).map(BaseOptions::build).orElseGet(Collections::emptyMap)).build();
            CommandExecutionHelper.executeScript(this.assertExtensionExists("mobile: activateApp"), "mobile: activateApp", (Map<String, Object>)args);
        }
        catch (InvalidArgumentException | UnsupportedCommandException e) {
            ImmutableMap args = ImmutableMap.builder().put((Object)"bundleId", (Object)bundleId).putAll(Optional.ofNullable(options).map(opts -> Map.of("options", opts.build())).orElseGet(Map::of)).build();
            CommandExecutionHelper.execute(this.markExtensionAbsence("mobile: activateApp"), Map.entry(MobileCommand.ACTIVATE_APP, args));
        }
    }

    default public ApplicationState queryAppState(String bundleId) {
        String extName = "mobile: queryAppState";
        try {
            return ApplicationState.ofCode(Objects.requireNonNull((Long)CommandExecutionHelper.executeScript(this.assertExtensionExists("mobile: queryAppState"), "mobile: queryAppState", Map.of("bundleId", bundleId, "appId", bundleId))));
        }
        catch (InvalidArgumentException | UnsupportedCommandException e) {
            return ApplicationState.ofCode(Objects.requireNonNull((Long)CommandExecutionHelper.execute(this.markExtensionAbsence("mobile: queryAppState"), Map.entry(MobileCommand.QUERY_APP_STATE, Map.of("bundleId", bundleId)))));
        }
    }

    default public boolean terminateApp(String bundleId) {
        return this.terminateApp(bundleId, null);
    }

    default public boolean terminateApp(String bundleId, @Nullable BaseTerminateApplicationOptions options) {
        String extName = "mobile: terminateApp";
        try {
            ImmutableMap args = ImmutableMap.builder().put((Object)"bundleId", (Object)bundleId).put((Object)"appId", (Object)bundleId).putAll(Optional.ofNullable(options).map(BaseOptions::build).orElseGet(Collections::emptyMap)).build();
            return Objects.requireNonNull((Boolean)CommandExecutionHelper.executeScript(this.assertExtensionExists("mobile: terminateApp"), "mobile: terminateApp", (Map<String, Object>)args));
        }
        catch (InvalidArgumentException | UnsupportedCommandException e) {
            ImmutableMap args = ImmutableMap.builder().put((Object)"bundleId", (Object)bundleId).putAll(Optional.ofNullable(options).map(opts -> Map.of("options", opts.build())).orElseGet(Map::of)).build();
            return Objects.requireNonNull((Boolean)CommandExecutionHelper.execute(this.markExtensionAbsence("mobile: terminateApp"), Map.entry(MobileCommand.TERMINATE_APP, args)));
        }
    }
}

