/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.android.appmanagement;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.appium.java_client.appmanagement.BaseRemoveApplicationOptions;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AndroidRemoveApplicationOptions
extends BaseRemoveApplicationOptions<AndroidRemoveApplicationOptions> {
    private Duration timeout;
    private Boolean keepData;

    public AndroidRemoveApplicationOptions withTimeout(Duration timeout) {
        Preconditions.checkArgument((!Objects.requireNonNull(timeout).isNegative() ? 1 : 0) != 0, (Object)"The timeout value cannot be negative");
        this.timeout = timeout;
        return this;
    }

    public AndroidRemoveApplicationOptions withKeepDataEnabled() {
        this.keepData = true;
        return this;
    }

    public AndroidRemoveApplicationOptions withKeepDataDisabled() {
        this.keepData = false;
        return this;
    }

    @Override
    public Map<String, Object> build() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Optional.ofNullable(this.timeout).ifPresent(x -> builder.put((Object)"timeout", (Object)x.toMillis()));
        Optional.ofNullable(this.keepData).ifPresent(x -> builder.put((Object)"keepData", x));
        return builder.build();
    }
}

