/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.utils.Bytes;
import io.appulse.utils.BytesAbstract;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import lombok.NonNull;

class BytesByteBuf
extends BytesAbstract {
    @NonNull
    private final ByteBuf buffer;

    static BytesByteBuf copy(@NonNull ByteBuf buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked @NonNull but is null");
        }
        ByteBuf copy = buffer.copy();
        return new BytesByteBuf(copy);
    }

    @Override
    public boolean isResizable() {
        return false;
    }

    @Override
    public Bytes writeNB(byte[] bytes, int offset, int length) {
        this.buffer.writeBytes(bytes, offset, length);
        return this;
    }

    @Override
    public Bytes write1B(byte value) {
        this.buffer.writeByte((int)value);
        return this;
    }

    @Override
    public Bytes write2B(short value) {
        this.buffer.writeShort((int)value);
        return this;
    }

    @Override
    public Bytes write4B(int value) {
        this.buffer.writeInt(value);
        return this;
    }

    @Override
    public Bytes write8B(long value) {
        this.buffer.writeLong(value);
        return this;
    }

    @Override
    public Bytes setNB(int index, byte[] bytes, int offset, int length) {
        this.buffer.setBytes(index, bytes, offset, length);
        return this;
    }

    @Override
    public Bytes set1B(int index, byte value) {
        this.buffer.setByte(index, (int)value);
        return this;
    }

    @Override
    public Bytes set2B(int index, short value) {
        this.buffer.setShort(index, (int)value);
        return this;
    }

    @Override
    public Bytes set4B(int index, int value) {
        this.buffer.setInt(index, value);
        return this;
    }

    @Override
    public Bytes set8B(int index, long value) {
        this.buffer.setLong(index, value);
        return this;
    }

    @Override
    public byte readByte() {
        return this.buffer.readByte();
    }

    @Override
    public short readShort() {
        return this.buffer.readShort();
    }

    @Override
    public int readInt() {
        return this.buffer.readInt();
    }

    @Override
    public long readLong() {
        return this.buffer.readLong();
    }

    @Override
    public float readFloat() {
        return this.buffer.readFloat();
    }

    @Override
    public double readDouble() {
        return this.buffer.readDouble();
    }

    @Override
    public char readChar() {
        return this.buffer.readChar();
    }

    @Override
    public Bytes readBytes(byte[] destination, int offset, int length) {
        this.buffer.readBytes(destination, offset, length);
        return this;
    }

    @Override
    public byte getByte(int index) {
        return this.buffer.getByte(index);
    }

    @Override
    public short getShort(int index) {
        return this.buffer.getShort(index);
    }

    @Override
    public int getInt(int index) {
        return this.buffer.getInt(index);
    }

    @Override
    public long getLong(int index) {
        return this.buffer.getLong(index);
    }

    @Override
    public float getFloat(int index) {
        return this.buffer.getFloat(index);
    }

    @Override
    public double getDouble(int index) {
        return this.buffer.getDouble(index);
    }

    @Override
    public char getChar(int index) {
        return this.buffer.getChar(index);
    }

    @Override
    public byte[] getBytes(int index, int length) {
        byte[] result = new byte[length];
        this.buffer.getBytes(index, result);
        return result;
    }

    @Override
    public String getString(int index, int length, Charset charset) {
        byte[] bytes = this.getBytes(index, length);
        return new String(bytes, charset);
    }

    @Override
    public int capacity() {
        return this.buffer.capacity();
    }

    @Override
    public int writerIndex() {
        return this.buffer.writerIndex();
    }

    @Override
    public Bytes writerIndex(int newIndex) {
        this.buffer.writerIndex(newIndex);
        return this;
    }

    @Override
    public int readerIndex() {
        return this.buffer.readerIndex();
    }

    @Override
    public Bytes readerIndex(int newIndex) {
        this.buffer.readerIndex(newIndex);
        return this;
    }

    @Override
    public byte[] array() {
        return this.buffer.array();
    }

    @SuppressFBWarnings(justification="generated code")
    BytesByteBuf(@NonNull ByteBuf buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked @NonNull but is null");
        }
        this.buffer = buffer;
    }
}

