/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils;

import io.appulse.utils.BytesByteBuffer;
import io.appulse.utils.BytesExtendableArray;
import io.appulse.utils.BytesFixedArray;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public interface Bytes {
    public static Bytes wrap(byte[] bytes) {
        return new BytesFixedArray(bytes);
    }

    public static Bytes wrap(ByteBuffer buffer) {
        return new BytesByteBuffer(buffer);
    }

    public static Bytes copy(byte[] bytes) {
        return BytesFixedArray.copy(bytes);
    }

    public static Bytes copy(ByteBuffer buffer) {
        return BytesByteBuffer.copy(buffer);
    }

    public static Bytes allocate(int size) {
        return new BytesFixedArray(size);
    }

    public static Bytes resizableArray() {
        return new BytesExtendableArray();
    }

    public static Bytes resizableArray(int initialSize) {
        return new BytesExtendableArray(initialSize);
    }

    public boolean isAutoResizable();

    public Bytes writeNB(byte[] var1);

    public Bytes writeNB(byte[] var1, int var2);

    public Bytes writeNB(byte[] var1, int var2, int var3);

    public Bytes writeNB(String var1);

    public Bytes writeNB(String var1, Charset var2);

    public Bytes write1B(byte var1);

    public Bytes write1B(short var1);

    public Bytes write1B(int var1);

    public Bytes write1B(long var1);

    public Bytes write1B(float var1);

    public Bytes write1B(double var1);

    public Bytes write1B(char var1);

    public Bytes write2B(byte var1);

    public Bytes write2B(short var1);

    public Bytes write2B(int var1);

    public Bytes write2B(long var1);

    public Bytes write2B(float var1);

    public Bytes write2B(double var1);

    public Bytes write2B(char var1);

    public Bytes write4B(byte var1);

    public Bytes write4B(short var1);

    public Bytes write4B(int var1);

    public Bytes write4B(long var1);

    public Bytes write4B(float var1);

    public Bytes write4B(double var1);

    public Bytes write4B(char var1);

    public Bytes write8B(byte var1);

    public Bytes write8B(short var1);

    public Bytes write8B(int var1);

    public Bytes write8B(long var1);

    public Bytes write8B(float var1);

    public Bytes write8B(double var1);

    public Bytes write8B(char var1);

    public Bytes setNB(int var1, byte[] var2);

    public Bytes setNB(int var1, byte[] var2, int var3);

    public Bytes setNB(int var1, byte[] var2, int var3, int var4);

    public Bytes setNB(int var1, String var2);

    public Bytes setNB(int var1, String var2, Charset var3);

    public Bytes set1B(int var1, byte var2);

    public Bytes set1B(int var1, short var2);

    public Bytes set1B(int var1, int var2);

    public Bytes set1B(int var1, long var2);

    public Bytes set1B(int var1, float var2);

    public Bytes set1B(int var1, double var2);

    public Bytes set1B(int var1, char var2);

    public Bytes set2B(int var1, byte var2);

    public Bytes set2B(int var1, short var2);

    public Bytes set2B(int var1, int var2);

    public Bytes set2B(int var1, long var2);

    public Bytes set2B(int var1, float var2);

    public Bytes set2B(int var1, double var2);

    public Bytes set2B(int var1, char var2);

    public Bytes set4B(int var1, byte var2);

    public Bytes set4B(int var1, short var2);

    public Bytes set4B(int var1, int var2);

    public Bytes set4B(int var1, long var2);

    public Bytes set4B(int var1, float var2);

    public Bytes set4B(int var1, double var2);

    public Bytes set4B(int var1, char var2);

    public Bytes set8B(int var1, byte var2);

    public Bytes set8B(int var1, short var2);

    public Bytes set8B(int var1, int var2);

    public Bytes set8B(int var1, long var2);

    public Bytes set8B(int var1, float var2);

    public Bytes set8B(int var1, double var2);

    public Bytes set8B(int var1, char var2);

    public byte readByte();

    public short readUnsignedByte();

    public short readShort();

    public int readUnsignedShort();

    public int readInt();

    public long readUnsignedInt();

    public long readLong();

    public BigInteger readUnsignedLong();

    public float readFloat();

    public double readDouble();

    public char readChar();

    public byte[] readBytes();

    public byte[] readBytes(int var1);

    public Bytes readBytes(byte[] var1);

    public Bytes readBytes(byte[] var1, int var2, int var3);

    public String readString();

    public String readString(Charset var1);

    public String readString(int var1);

    public String readString(int var1, Charset var2);

    public byte getByte(int var1);

    public short getUnsignedByte(int var1);

    public short getShort(int var1);

    public int getUnsignedShort(int var1);

    public int getInt(int var1);

    public long getUnsignedInt(int var1);

    public long getLong(int var1);

    public BigInteger getUnsignedLong(int var1);

    public float getFloat(int var1);

    public double getDouble(int var1);

    public char getChar(int var1);

    public byte[] getBytes(int var1);

    public byte[] getBytes(int var1, int var2);

    public String getString(int var1);

    public String getString(int var1, Charset var2);

    public String getString(int var1, int var2);

    public String getString(int var1, int var2, Charset var3);

    public int capacity();

    public void capacity(int var1);

    public int writerIndex();

    public Bytes writerIndex(int var1);

    public int writableBytes();

    public boolean isWritable();

    public boolean isWritable(int var1);

    public int readerIndex();

    public Bytes readerIndex(int var1);

    public int readableBytes();

    public boolean isReadable();

    public boolean isReadable(int var1);

    public Bytes reset();

    public byte[] array();

    public byte[] arrayCopy();
}

