/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils.threads;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

final class CompletablePromiseContext {
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();

    static CompletablePromiseContext getInstance() {
        return LazyHolder.INSTANCE;
    }

    CompletablePromiseContext() {
    }

    void schedule(Runnable runnable) {
        this.scheduler.schedule(runnable, 1L, TimeUnit.MILLISECONDS);
    }

    private static class LazyHolder {
        static final CompletablePromiseContext INSTANCE = new CompletablePromiseContext();

        private LazyHolder() {
        }
    }
}

