/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.utils.Bytes;
import io.appulse.utils.BytesFixedArray;
import java.util.Arrays;

class BytesExtendableArray
extends BytesFixedArray {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    BytesExtendableArray() {
        this(16);
    }

    BytesExtendableArray(int initialSize) {
        super(initialSize);
    }

    @Override
    public boolean isAutoResizable() {
        return true;
    }

    @Override
    public Bytes writerIndex(int newIndex) {
        if (newIndex < this.readerIndex()) {
            throw new IndexOutOfBoundsException();
        }
        this.checkWriteBounds(newIndex, 1);
        this.writerIndex = newIndex;
        return this;
    }

    @Override
    protected void checkWriteBounds(int index, int length) {
        int neededCapacity;
        int currentCapacity = this.capacity();
        if (currentCapacity >= (neededCapacity = index + length)) {
            return;
        }
        int newCapacity = currentCapacity * 2;
        if (newCapacity - neededCapacity < 0) {
            newCapacity = neededCapacity;
        }
        if (newCapacity - 0x7FFFFFF7 > 0) {
            newCapacity = neededCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
        }
        this.buffer = Arrays.copyOf(this.buffer, newCapacity);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BytesExtendableArray)) {
            return false;
        }
        BytesExtendableArray other = (BytesExtendableArray)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof BytesExtendableArray;
    }

    @Override
    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

