/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.appulse.utils.Bytes;
import io.appulse.utils.BytesAbstract;
import java.nio.charset.Charset;

class BytesReadOnly
extends BytesAbstract {
    private final Bytes delegate;
    private int readerIndex;

    @Override
    public boolean isAutoResizable() {
        return false;
    }

    @Override
    public Bytes writeNB(byte[] bytes, int offset, int length) {
        String msg = "The operation doesn't support in BytesReadOnly wrapper";
        throw new UnsupportedOperationException("The operation doesn't support in BytesReadOnly wrapper");
    }

    @Override
    public Bytes write1B(byte value) {
        String msg = "The operation doesn't support in BytesReadOnly wrapper";
        throw new UnsupportedOperationException("The operation doesn't support in BytesReadOnly wrapper");
    }

    @Override
    public Bytes write2B(short value) {
        String msg = "The operation doesn't support in BytesReadOnly wrapper";
        throw new UnsupportedOperationException("The operation doesn't support in BytesReadOnly wrapper");
    }

    @Override
    public Bytes write4B(int value) {
        String msg = "The operation doesn't support in BytesReadOnly wrapper";
        throw new UnsupportedOperationException("The operation doesn't support in BytesReadOnly wrapper");
    }

    @Override
    public Bytes write8B(long value) {
        String msg = "The operation doesn't support in BytesReadOnly wrapper";
        throw new UnsupportedOperationException("The operation doesn't support in BytesReadOnly wrapper");
    }

    @Override
    public Bytes setNB(int index, byte[] bytes, int offset, int length) {
        String msg = "The operation doesn't support in BytesReadOnly wrapper";
        throw new UnsupportedOperationException("The operation doesn't support in BytesReadOnly wrapper");
    }

    @Override
    public Bytes set1B(int index, byte value) {
        String msg = "The operation doesn't support in BytesReadOnly wrapper";
        throw new UnsupportedOperationException("The operation doesn't support in BytesReadOnly wrapper");
    }

    @Override
    public Bytes set2B(int index, short value) {
        String msg = "The operation doesn't support in BytesReadOnly wrapper";
        throw new UnsupportedOperationException("The operation doesn't support in BytesReadOnly wrapper");
    }

    @Override
    public Bytes set4B(int index, int value) {
        String msg = "The operation doesn't support in BytesReadOnly wrapper";
        throw new UnsupportedOperationException("The operation doesn't support in BytesReadOnly wrapper");
    }

    @Override
    public Bytes set8B(int index, long value) {
        String msg = "The operation doesn't support in BytesReadOnly wrapper";
        throw new UnsupportedOperationException("The operation doesn't support in BytesReadOnly wrapper");
    }

    @Override
    public byte readByte() {
        byte result = this.getByte(this.readerIndex);
        ++this.readerIndex;
        return result;
    }

    @Override
    public short readShort() {
        short result = this.getShort(this.readerIndex);
        this.readerIndex += 2;
        return result;
    }

    @Override
    public int readInt() {
        int result = this.getInt(this.readerIndex);
        this.readerIndex += 4;
        return result;
    }

    @Override
    public long readLong() {
        long result = this.getLong(this.readerIndex);
        this.readerIndex += 8;
        return result;
    }

    @Override
    public float readFloat() {
        float result = this.getFloat(this.readerIndex);
        this.readerIndex += 4;
        return result;
    }

    @Override
    public double readDouble() {
        double result = this.getDouble(this.readerIndex);
        this.readerIndex += 8;
        return result;
    }

    @Override
    public char readChar() {
        char result = this.getChar(this.readerIndex);
        this.readerIndex += 2;
        return result;
    }

    @Override
    public Bytes readBytes(byte[] destination, int offset, int length) {
        this.checkReaderBounds(this.readerIndex, length);
        System.arraycopy(this.array(), this.readerIndex, destination, offset, length);
        this.readerIndex += length;
        return this;
    }

    @Override
    public byte getByte(int index) {
        return this.delegate.getByte(index);
    }

    @Override
    public short getShort(int index) {
        return this.delegate.getShort(index);
    }

    @Override
    public int getInt(int index) {
        return this.delegate.getInt(index);
    }

    @Override
    public long getLong(int index) {
        return this.delegate.getLong(index);
    }

    @Override
    public float getFloat(int index) {
        return this.delegate.getFloat(index);
    }

    @Override
    public double getDouble(int index) {
        return this.delegate.getDouble(index);
    }

    @Override
    public char getChar(int index) {
        return this.delegate.getChar(index);
    }

    @Override
    public byte[] getBytes(int index, int length) {
        return this.delegate.getBytes(index, length);
    }

    @Override
    public String getString(int index, int length, Charset charset) {
        return this.delegate.getString(index, length, charset);
    }

    @Override
    public int capacity() {
        return this.delegate.capacity();
    }

    @Override
    public void capacity(int bytes) {
        String msg = "The operation doesn't support in BytesReadOnly wrapper";
        throw new UnsupportedOperationException("The operation doesn't support in BytesReadOnly wrapper");
    }

    @Override
    public int writerIndex() {
        return this.delegate.writerIndex();
    }

    @Override
    public Bytes writerIndex(int newIndex) {
        String msg = "The operation doesn't support in BytesReadOnly wrapper";
        throw new UnsupportedOperationException("The operation doesn't support in BytesReadOnly wrapper");
    }

    @Override
    public int readerIndex() {
        return this.readerIndex;
    }

    @Override
    public Bytes readerIndex(int newIndex) {
        if (newIndex < 0 || newIndex > this.writerIndex()) {
            String msg = String.format("Reader index error: newIndex(%d) < 0 || newIndex(%d) > writerIndex(%d)", newIndex, newIndex, this.writerIndex());
            throw new IndexOutOfBoundsException(msg);
        }
        this.readerIndex = newIndex;
        return this;
    }

    @Override
    public byte[] array() {
        return this.delegate.array();
    }

    @SuppressFBWarnings(justification="generated code")
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BytesReadOnly)) {
            return false;
        }
        BytesReadOnly other = (BytesReadOnly)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Bytes this$delegate = this.delegate;
        Bytes other$delegate = other.delegate;
        if (this$delegate == null ? other$delegate != null : !this$delegate.equals(other$delegate)) {
            return false;
        }
        return this.readerIndex == other.readerIndex;
    }

    @SuppressFBWarnings(justification="generated code")
    protected boolean canEqual(Object other) {
        return other instanceof BytesReadOnly;
    }

    @SuppressFBWarnings(justification="generated code")
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Bytes $delegate = this.delegate;
        result = result * 59 + ($delegate == null ? 43 : $delegate.hashCode());
        result = result * 59 + this.readerIndex;
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    BytesReadOnly(Bytes delegate) {
        this.delegate = delegate;
    }
}

