/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils;

import io.appulse.utils.Bytes;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Locale;
import lombok.NonNull;

public final class ReadBytesUtils {
    public static Bytes read(@NonNull InputStream inputStream) {
        int readed;
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        Bytes buffer = Bytes.resizableArray(64);
        while ((readed = inputStream.read(buffer.array(), buffer.writerIndex(), buffer.writableBytes())) != -1) {
            buffer.writerIndex(buffer.writerIndex() + readed);
            if (buffer.isWritable()) continue;
            buffer.capacity(buffer.capacity() * 2);
        }
        return buffer;
    }

    public static Bytes read(@NonNull InputStream inputStream, int length) {
        int readed;
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        if (length < 0) {
            String msg = String.format(Locale.ENGLISH, "Invalid length %d. The length must be greater or equal 0", length);
            throw new IndexOutOfBoundsException(msg);
        }
        Bytes buffer = Bytes.allocate(length);
        int offset = 0;
        for (int remaining = length; remaining > 0 && (readed = inputStream.read(buffer.array(), offset, remaining)) != -1; remaining -= readed) {
            offset += readed;
        }
        buffer.writerIndex(offset);
        return buffer;
    }

    public static int read(InputStream inputStream, @NonNull byte[] buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        return ReadBytesUtils.read(inputStream, buffer, 0, buffer.length);
    }

    public static int read(InputStream inputStream, @NonNull Bytes buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        return ReadBytesUtils.read(inputStream, buffer, buffer.writableBytes());
    }

    public static int read(InputStream inputStream, @NonNull ByteBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        return ReadBytesUtils.read(inputStream, buffer, buffer.remaining());
    }

    public static int read(InputStream inputStream, byte[] buffer, int length) {
        return ReadBytesUtils.read(inputStream, buffer, 0, length);
    }

    public static int read(@NonNull InputStream inputStream, @NonNull Bytes buffer, int length) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        int readed = ReadBytesUtils.read(inputStream, buffer.array(), buffer.writerIndex(), length);
        buffer.writerIndex(buffer.writerIndex() + readed);
        return readed;
    }

    public static int read(@NonNull InputStream inputStream, @NonNull ByteBuffer buffer, int length) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        int readed = ReadBytesUtils.read(inputStream, buffer.array(), buffer.position(), length);
        buffer.position(buffer.position() + readed);
        return readed;
    }

    public static int read(@NonNull InputStream inputStream, @NonNull byte[] bytes, int offset, int length) {
        int readed;
        if (inputStream == null) {
            throw new NullPointerException("inputStream is marked non-null but is null");
        }
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (offset < 0 || offset >= bytes.length) {
            String msg = String.format(Locale.ENGLISH, "Invalid offset %d. The offset must be equal or greater than 0 and less than byte array length", offset);
            throw new IndexOutOfBoundsException(msg);
        }
        if (length < 0) {
            String msg = String.format(Locale.ENGLISH, "Invalid length %d. The length must be greater or equal 0", length);
            throw new IndexOutOfBoundsException(msg);
        }
        int position = offset;
        for (int remaining = Math.min(bytes.length - offset, length); remaining > 0 && (readed = inputStream.read(bytes, position, remaining)) >= 0; remaining -= readed) {
            position += readed;
        }
        return position - offset;
    }

    public static int read(ReadableByteChannel channel, @NonNull byte[] buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        return ReadBytesUtils.read(channel, buffer, 0, buffer.length);
    }

    public static int read(ReadableByteChannel channel, byte[] buffer, int length) {
        return ReadBytesUtils.read(channel, buffer, 0, length);
    }

    public static int read(@NonNull ReadableByteChannel channel, @NonNull byte[] bytes, int offset, int length) {
        int readed;
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        if (offset < 0 || offset >= bytes.length) {
            String msg = String.format(Locale.ENGLISH, "Invalid offset %d. The offset must be equal or greater than 0 and less than byte array length", offset);
            throw new IndexOutOfBoundsException(msg);
        }
        if (length < 0) {
            String msg = String.format(Locale.ENGLISH, "Invalid length %d. The length must be greater or equal 0", length);
            throw new IndexOutOfBoundsException(msg);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.position(offset);
        int limit = Math.min(offset + length, bytes.length);
        byteBuffer.limit(limit);
        int totalReaded = 0;
        while (byteBuffer.hasRemaining() && (readed = channel.read(byteBuffer)) >= 0) {
            totalReaded += readed;
        }
        return totalReaded;
    }

    public static int read(ReadableByteChannel channel, @NonNull ByteBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        return ReadBytesUtils.read(channel, buffer, buffer.remaining());
    }

    public static int read(@NonNull ReadableByteChannel channel, @NonNull ByteBuffer buffer, int length) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        int readed = ReadBytesUtils.read(channel, buffer.array(), length);
        buffer.position(buffer.position() + readed);
        return readed;
    }

    public static int read(ReadableByteChannel channel, @NonNull Bytes buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        return ReadBytesUtils.read(channel, buffer, buffer.writableBytes());
    }

    public static int read(@NonNull ReadableByteChannel channel, @NonNull Bytes buffer, int length) {
        if (channel == null) {
            throw new NullPointerException("channel is marked non-null but is null");
        }
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        int readed = ReadBytesUtils.read(channel, buffer.array(), buffer.writerIndex(), length);
        buffer.writerIndex(buffer.writerIndex() + readed);
        return readed;
    }

    public static int read(File file, @NonNull byte[] buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        return ReadBytesUtils.read(file, buffer, 0, buffer.length);
    }

    public static int read(Path path, @NonNull byte[] buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        return ReadBytesUtils.read(path, buffer, 0, buffer.length);
    }

    public static int read(File file, byte[] buffer, int length) {
        return ReadBytesUtils.read(file, buffer, 0, length);
    }

    public static int read(Path path, byte[] buffer, int length) {
        return ReadBytesUtils.read(path, buffer, 0, length);
    }

    public static int read(@NonNull File file, byte[] buffer, int offset, int length) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return ReadBytesUtils.read(file.toPath(), buffer, offset, length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int read(@NonNull Path path, byte[] buffer, int offset, int length) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        try (SeekableByteChannel channel = Files.newByteChannel(path, StandardOpenOption.READ);){
            int n = ReadBytesUtils.read(channel, buffer, offset, length);
            return n;
        }
    }

    public static int read(File file, @NonNull Bytes buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        return ReadBytesUtils.read(file, buffer, buffer.writableBytes());
    }

    public static int read(Path path, @NonNull Bytes buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        return ReadBytesUtils.read(path, buffer, buffer.writableBytes());
    }

    public static int read(@NonNull File file, Bytes buffer, int length) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return ReadBytesUtils.read(file.toPath(), buffer, length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int read(@NonNull Path path, Bytes buffer, int length) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        try (SeekableByteChannel channel = Files.newByteChannel(path, StandardOpenOption.READ);){
            int n = ReadBytesUtils.read((ReadableByteChannel)channel, buffer, length);
            return n;
        }
    }

    public static int read(File file, @NonNull ByteBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        return ReadBytesUtils.read(file, buffer, buffer.remaining());
    }

    public static int read(Path path, @NonNull ByteBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        return ReadBytesUtils.read(path, buffer, buffer.remaining());
    }

    public static int read(@NonNull File file, ByteBuffer buffer, int length) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return ReadBytesUtils.read(file.toPath(), buffer, length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int read(@NonNull Path path, ByteBuffer buffer, int length) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        try (SeekableByteChannel channel = Files.newByteChannel(path, StandardOpenOption.READ);){
            int n = ReadBytesUtils.read((ReadableByteChannel)channel, buffer, length);
            return n;
        }
    }

    private ReadBytesUtils() {
        throw new UnsupportedOperationException();
    }
}

