/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.NonNull;

public final class ReflectionUtils {
    public static Optional<Object> getFieldValueFrom(@NonNull Object obj, @NonNull String name) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        Optional<Field> optional = ReflectionUtils.findIn(obj, Class::getDeclaredFields, field -> field.getName().equals(name));
        if (optional.isPresent()) {
            final Field field2 = optional.get();
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    field2.setAccessible(true);
                    return null;
                }
            });
            Object value = field2.get(obj);
            return Optional.ofNullable(value);
        }
        return Optional.empty();
    }

    public static Object invokeMethodOf(@NonNull Object obj, @NonNull String name, Object ... arguments) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        Optional<Method> optional = ReflectionUtils.findIn(obj, Class::getDeclaredMethods, method -> method.getName().equals(name));
        if (optional.isPresent()) {
            Method method2 = optional.get();
            return method2.invoke(obj, arguments);
        }
        return null;
    }

    private static <T> Optional<T> findIn(Object obj, Function<Class<?>, T[]> extractor, Predicate<T> predicate) {
        for (Class<?> current = obj.getClass(); current != null; current = current.getSuperclass()) {
            T[] values = extractor.apply(current);
            Optional<T> optional = Stream.of(values).filter(predicate).findFirst();
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    private ReflectionUtils() {
    }
}

