/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils;

import io.appulse.utils.Bytes;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

public final class SocketUtils {
    public static Optional<Integer> findFreePort() {
        return SocketUtils.findFreePort(1024, 65535);
    }

    public static Optional<Integer> findFreePort(int from, int to) {
        for (int port = from; port <= to; ++port) {
            if (!SocketUtils.isPortAvailable(port)) continue;
            return Optional.of(port);
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isPortAvailable(int port) {
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress("localhost", port), (int)TimeUnit.SECONDS.toMillis(1L));
            boolean bl = false;
            return bl;
        }
        catch (IOException ex) {
            return true;
        }
    }

    public static byte[] read(@NonNull InputStream stream) {
        int length;
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(32);
        byte[] buffer = new byte[32];
        while ((length = stream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, length);
        }
        return outputStream.toByteArray();
    }

    public static byte[] read(@NonNull Socket socket) {
        if (socket == null) {
            throw new NullPointerException("socket");
        }
        return SocketUtils.read(socket.getInputStream());
    }

    public static byte[] read(@NonNull InputStream stream, int length) {
        int count;
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException();
        }
        byte[] result = new byte[length];
        for (int readed = 0; readed < length; readed += count) {
            count = stream.read(result, readed, length - readed);
            if (count >= -1) continue;
            throw new EOFException();
        }
        return result;
    }

    public static byte[] read(@NonNull Socket socket, int length) {
        if (socket == null) {
            throw new NullPointerException("socket");
        }
        return SocketUtils.read(socket.getInputStream(), length);
    }

    public static Bytes readBytes(@NonNull InputStream stream) {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        byte[] result = SocketUtils.read(stream);
        return Bytes.wrap(result);
    }

    public static Bytes readBytes(@NonNull Socket socket) {
        if (socket == null) {
            throw new NullPointerException("socket");
        }
        return SocketUtils.readBytes(socket.getInputStream());
    }

    public static Bytes readBytes(@NonNull InputStream stream, int length) {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        byte[] result = SocketUtils.read(stream, length);
        return Bytes.wrap(result);
    }

    public static Bytes readBytes(@NonNull Socket socket, int fixedLength) {
        if (socket == null) {
            throw new NullPointerException("socket");
        }
        return SocketUtils.readBytes(socket.getInputStream(), fixedLength);
    }

    private SocketUtils() {
    }
}

