/*
 * Decompiled with CFR 0.152.
 */
package io.bindingz.api.client;

import io.bindingz.api.annotations.jackson.JacksonConfiguration;
import io.bindingz.api.client.SchemaService;
import io.bindingz.api.client.jackson.JacksonSchemaService;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class SchemaServiceFactory {
    private List<ClassLoader> classLoaders;
    private Map<Annotation, SchemaService> schemaServices = new HashMap<Annotation, SchemaService>();
    private AtomicReference<JacksonSchemaService> defaultService = new AtomicReference();

    public SchemaServiceFactory(List<ClassLoader> classLoaders) {
        this.classLoaders = classLoaders;
    }

    public SchemaService getSchemaService(Class contract) {
        JacksonConfiguration configuration = contract.getAnnotation(JacksonConfiguration.class);
        if (configuration != null) {
            return this.schemaServices.computeIfAbsent((Annotation)configuration, conf -> new JacksonSchemaService(this.classLoaders, configuration));
        }
        JacksonSchemaService service = this.defaultService.get();
        if (service == null) {
            this.defaultService.set(new JacksonSchemaService(this.classLoaders));
        }
        return this.defaultService.get();
    }
}

