/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.api;

import io.jafar.parser.api.Control;
import io.jafar.parser.internal_api.metadata.MetadataClass;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class JafarRecordedEvent {
    private final MetadataClass type;
    private final Map<String, Object> value;
    private final long streamPosition;
    private final Control.ChunkInfo chunkInfo;

    public JafarRecordedEvent(MetadataClass type, Map<String, Object> value, long streamPosition, Control.ChunkInfo chunkInfo) {
        this.type = type;
        this.value = Collections.unmodifiableMap(value);
        this.streamPosition = streamPosition;
        this.chunkInfo = chunkInfo;
    }

    public MetadataClass type() {
        return this.type;
    }

    public Map<String, Object> value() {
        return this.value;
    }

    public long streamPosition() {
        return this.streamPosition;
    }

    public Control.ChunkInfo chunkInfo() {
        return this.chunkInfo;
    }

    public String typeName() {
        return this.type.getName();
    }

    public long typeId() {
        return this.type.getId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JafarRecordedEvent that = (JafarRecordedEvent)o;
        return this.streamPosition == that.streamPosition && Objects.equals(this.type, that.type) && Objects.equals(this.value, that.value) && Objects.equals(this.chunkInfo, that.chunkInfo);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.value, this.streamPosition, this.chunkInfo);
    }

    public String toString() {
        return "JafarRecordedEvent{type=" + (this.type != null ? this.type.getName() : "null") + ", streamPosition=" + this.streamPosition + ", valueSize=" + (this.value != null ? this.value.size() : 0) + '}';
    }
}

