/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.impl;

import io.jafar.parser.api.ParserContext;
import io.jafar.parser.impl.ArrayHolder;
import io.jafar.parser.impl.ConstantPoolAccessor;
import io.jafar.parser.impl.LazyEventMap;
import io.jafar.parser.impl.MultiTypeStack;
import io.jafar.parser.internal_api.ValueProcessor;
import io.jafar.parser.internal_api.metadata.MetadataClass;
import java.util.HashMap;
import java.util.Map;

public final class LazyMapValueBuilder
implements ValueProcessor {
    public static final ThreadLocal<ArrayPool> ARRAY_POOL = ThreadLocal.withInitial(ArrayPool::new);
    private final ParserContext context;
    private final MultiTypeStack stack = new MultiTypeStack(20);
    private Map<String, Object> root;

    LazyMapValueBuilder(ParserContext context) {
        this.context = context;
    }

    void reset() {
        this.root = null;
    }

    Map<String, Object> getRoot() {
        return this.root;
    }

    @Override
    public void onStringValue(MetadataClass owner, String fld, String value) {
        this.addFieldValue(fld, value);
    }

    @Override
    public void onShortValue(MetadataClass type, String fld, short value) {
        this.addFieldValue(fld, value);
    }

    @Override
    public void onCharValue(MetadataClass type, String fld, char value) {
        this.addFieldValue(fld, Character.valueOf(value));
    }

    @Override
    public void onIntValue(MetadataClass owner, String fld, long value) {
        this.addFieldValue(fld, value);
    }

    @Override
    public void onLongValue(MetadataClass type, String fld, long value) {
        this.addFieldValue(fld, value);
    }

    @Override
    public void onByteValue(MetadataClass type, String fld, byte value) {
        this.addFieldValue(fld, value);
    }

    @Override
    public void onBooleanValue(MetadataClass owner, String fld, boolean value) {
        this.addFieldValue(fld, value);
    }

    @Override
    public void onDoubleValue(MetadataClass owner, String fld, double value) {
        this.addFieldValue(fld, value);
    }

    @Override
    public void onFloatValue(MetadataClass owner, String fld, float value) {
        this.addFieldValue(fld, Float.valueOf(value));
    }

    @Override
    public void onComplexValueStart(MetadataClass owner, String fld, MetadataClass type) {
        if (owner == null && fld == null) {
            ArrayPool pool = ARRAY_POOL.get();
            pool.reset();
            this.stack.push(pool);
        } else {
            HashMap value = new HashMap();
            this.stack.push(value);
        }
    }

    @Override
    public void onComplexValueEnd(MetadataClass owner, String fld, MetadataClass type) {
        ArrayHolder ah;
        ArrayPool pool = this.stack.pop(ArrayPool.class);
        Object value = pool;
        if (value == null) {
            value = this.stack.pop(Map.class);
        }
        assert (value != null);
        if (value instanceof ArrayPool) {
            ArrayPool ap = (ArrayPool)value;
            LazyEventMap lazyMap = new LazyEventMap(ap, ap.size);
            value = lazyMap;
        }
        if ((ah = this.stack.peek(ArrayHolder.class)) != null) {
            ah.add(value);
        } else if (owner != null && fld != null) {
            Object parent = this.stack.peek();
            if (parent instanceof ArrayPool) {
                ((ArrayPool)parent).add(fld, value);
            } else if (parent instanceof Map) {
                ((Map)parent).put(fld, value);
            }
        } else {
            this.root = (Map)value;
        }
    }

    @Override
    public void onArrayStart(MetadataClass owner, String fld, MetadataClass type, int len) {
        ArrayHolder arr = new ArrayHolder(type.getName(), len);
        this.stack.push(arr);
    }

    @Override
    public void onArrayEnd(MetadataClass owner, String fld, MetadataClass type) {
        ArrayHolder arr = this.stack.pop(ArrayHolder.class);
        assert (arr != null);
        Object parent = this.stack.peek();
        if (parent instanceof ArrayPool) {
            ((ArrayPool)parent).add(fld, arr);
        } else if (parent instanceof Map) {
            ((Map)parent).put(fld, arr);
        }
    }

    @Override
    public void onConstantPoolIndex(MetadataClass owner, String fld, MetadataClass type, long pointer) {
        ConstantPoolAccessor cpAccessor = new ConstantPoolAccessor(this.context, type, pointer);
        ArrayHolder ah = this.stack.peek(ArrayHolder.class);
        if (ah != null) {
            ah.add(cpAccessor);
        } else {
            Object parent = this.stack.peek();
            if (parent instanceof ArrayPool) {
                ((ArrayPool)parent).add(fld, cpAccessor);
            } else if (parent instanceof Map) {
                ((Map)parent).put(fld, cpAccessor);
            }
        }
    }

    private void addFieldValue(String fld, Object value) {
        ArrayHolder ah = this.stack.peek(ArrayHolder.class);
        if (ah != null) {
            ah.add(value);
        } else {
            Object parent = this.stack.peek();
            if (parent instanceof ArrayPool) {
                ((ArrayPool)parent).add(fld, value);
            } else if (parent instanceof Map) {
                ((Map)parent).put(fld, value);
            }
        }
    }

    public static class ArrayPool {
        private static final int INITIAL_CAPACITY = 24;
        public String[] keys = new String[24];
        public Object[] values = new Object[24];
        public int size = 0;

        public void reset() {
            for (int i = 0; i < this.size; ++i) {
                this.keys[i] = null;
                this.values[i] = null;
            }
            this.size = 0;
        }

        public void add(String key, Object value) {
            if (this.size >= this.keys.length) {
                int newCapacity = this.keys.length * 2;
                String[] newKeys = new String[newCapacity];
                Object[] newValues = new Object[newCapacity];
                System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
                System.arraycopy(this.values, 0, newValues, 0, this.values.length);
                this.keys = newKeys;
                this.values = newValues;
            }
            this.keys[this.size] = key;
            this.values[this.size] = value;
            ++this.size;
        }

        String[] getKeys() {
            String[] result = new String[this.size];
            System.arraycopy(this.keys, 0, result, 0, this.size);
            return result;
        }

        Object[] getValues() {
            Object[] result = new Object[this.size];
            System.arraycopy(this.values, 0, result, 0, this.size);
            return result;
        }
    }
}

