/*
 * Decompiled with CFR 0.152.
 */
package io.jafar.parser.internal_api;

import io.jafar.parser.internal_api.RecordingStream;
import io.jafar.parser.internal_api.ValueProcessor;
import io.jafar.parser.internal_api.metadata.MetadataClass;
import io.jafar.parser.internal_api.metadata.MetadataField;
import java.io.IOException;

public final class GenericValueReader {
    private final ValueProcessor processor;

    public GenericValueReader(ValueProcessor processor) {
        this.processor = processor;
    }

    public <T extends ValueProcessor> T getProcessor() {
        return (T)this.processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readValue(RecordingStream stream, MetadataClass type) throws IOException {
        if (type.isPrimitive()) {
            this.readSingleValue(stream, type, "");
        }
        for (MetadataField fld : type.getFields()) {
            if (fld.getDimension() == 1) {
                int len = (int)stream.readVarint();
                try {
                    this.processor.onArrayStart(type, fld.getName(), fld.getType(), len);
                    for (int i = 0; i < len; ++i) {
                        this.readSingleFieldValue(stream, type, fld);
                    }
                    continue;
                }
                finally {
                    this.processor.onArrayEnd(type, fld.getName(), fld.getType());
                    continue;
                }
            }
            this.readSingleFieldValue(stream, type, fld);
        }
    }

    private void readSingleFieldValue(RecordingStream stream, MetadataClass type, MetadataField fld) throws IOException {
        if (fld.hasConstantPool()) {
            long idx = stream.readVarint();
            this.processor.onConstantPoolIndex(type, fld.getName(), fld.getType(), idx);
        } else if (fld.getType().isPrimitive()) {
            this.readSingleValue(stream, fld.getType(), fld.getName());
        } else {
            this.processor.onComplexValueStart(type, fld.getName(), fld.getType());
            this.readValue(stream, fld.getType());
            this.processor.onComplexValueEnd(type, fld.getName(), fld.getType());
        }
    }

    public void readSingleValue(RecordingStream stream, MetadataClass type, String fldName) throws IOException {
        switch (type.getName()) {
            case "short": {
                this.processor.onShortValue(type, fldName, (short)stream.readVarint());
                break;
            }
            case "char": {
                this.processor.onCharValue(type, fldName, (char)stream.readVarint());
                break;
            }
            case "int": {
                this.processor.onIntValue(type, fldName, (int)stream.readVarint());
                break;
            }
            case "long": {
                this.processor.onLongValue(type, fldName, stream.readVarint());
                break;
            }
            case "byte": {
                this.processor.onByteValue(type, fldName, stream.read());
                break;
            }
            case "boolean": {
                this.processor.onBooleanValue(type, fldName, stream.read() != 0);
                break;
            }
            case "double": {
                this.processor.onDoubleValue(type, fldName, stream.readDouble());
                break;
            }
            case "float": {
                this.processor.onFloatValue(type, fldName, stream.readFloat());
                break;
            }
            case "java.lang.String": {
                this.processor.onStringValue(type, fldName, stream.readUTF8());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown primitive type: " + type);
            }
        }
    }
}

